/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class EcoCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"eco").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(EcoCommand.getOnlinePlayerNames((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> EcoCommand.addBalance((CommandContext<class_2168>)context)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(EcoCommand.getOnlinePlayerNames((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> EcoCommand.setBalance((CommandContext<class_2168>)context)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"take").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(EcoCommand.getOnlinePlayerNames((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> EcoCommand.takeBalance((CommandContext<class_2168>)context)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(EcoCommand.getOnlinePlayerNames((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(context -> EcoCommand.getBalance((CommandContext<class_2168>)context)))));
    }

    private static int addBalance(CommandContext<class_2168> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(playerName);
        if (player != null) {
            UUID playerUUID = player.method_5667();
            int currentBalance = (int)BalanceManager.getPlayerBalance(player);
            int newBalance = currentBalance + amount;
            BalanceManager.updatePlayerBalance(player, newBalance);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7a" + class_2561.method_43469((String)"command.eco.add.success", (Object[])new Object[]{amount, playerName, newBalance}).getString())), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7c" + class_2561.method_43471((String)"command.eco.player_not_found").getString())));
        return 0;
    }

    private static int setBalance(CommandContext<class_2168> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(playerName);
        if (player != null) {
            BalanceManager.updatePlayerBalance(player, amount);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7a" + class_2561.method_43469((String)"command.eco.set.success", (Object[])new Object[]{amount, playerName}).getString())), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7c" + class_2561.method_43471((String)"command.eco.player_not_found").getString())));
        return 0;
    }

    private static int takeBalance(CommandContext<class_2168> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(playerName);
        if (player != null) {
            int currentBalance = (int)BalanceManager.getPlayerBalance(player);
            int newBalance = currentBalance - amount;
            BalanceManager.updatePlayerBalance(player, newBalance);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7a" + class_2561.method_43469((String)"command.eco.take.success", (Object[])new Object[]{amount, playerName, newBalance}).getString())), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7c" + class_2561.method_43471((String)"command.eco.player_not_found").getString())));
        return 0;
    }

    private static int getBalance(CommandContext<class_2168> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(playerName);
        if (player != null) {
            int currentBalance = (int)BalanceManager.getPlayerBalance(player);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7a" + class_2561.method_43469((String)"command.eco.get.success", (Object[])new Object[]{playerName, currentBalance}).getString())), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7c" + class_2561.method_43471((String)"command.eco.player_not_found").getString())));
        return 0;
    }

    private static List<String> getOnlinePlayerNames(CommandContext<class_2168> context) {
        return ((class_2168)context.getSource()).method_9211().method_3760().method_14571().stream().map(class_1657::method_7334).map(profile -> profile.getName()).collect(Collectors.toList());
    }
}

