/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class LeaderboardCommand {
    private static LeaderboardData leaderboardData;

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"leaderboard").then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> LeaderboardCommand.createLeaderboard((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))).then(class_2170.method_9247((String)"delete").executes(LeaderboardCommand::deleteLeaderboards)));
    }

    private static int createLeaderboard(CommandContext<class_2168> context, int number) {
        class_2168 source = (class_2168)context.getSource();
        try {
            class_3222 player = source.method_9207();
            class_3218 world = player.method_51469();
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            class_2338 position = player.method_24515();
            Leaderboard newLeaderboard = new Leaderboard(position, number);
            leaderboardData.addLeaderboard(newLeaderboard);
            LeaderboardCommand.updateLeaderboard((class_1937)world, newLeaderboard);
            leaderboardData.method_80();
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7aLeaderboard created successfully."), true);
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cFailed to create leaderboard."));
            e.printStackTrace();
        }
        return 1;
    }

    private static int deleteLeaderboards(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            class_3222 player = source.method_9207();
            class_3218 world = player.method_51469();
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            class_2338 playerPos = player.method_24515();
            int radius = 5;
            List toRemove = leaderboardData.getLeaderboards().stream().filter(lb -> lb.getPosition().method_19771((class_2382)playerPos, (double)radius)).collect(Collectors.toList());
            for (Leaderboard leaderboard : toRemove) {
                leaderboard.getArmorStands().forEach(armorStand -> {
                    if (armorStand != null && !armorStand.method_31481()) {
                        armorStand.method_5768();
                    }
                });
                leaderboardData.removeLeaderboard(leaderboard);
            }
            leaderboardData.method_80();
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7aLeaderboards deleted successfully."), true);
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cFailed to delete leaderboards."));
            e.printStackTrace();
        }
        return 1;
    }

    public static void onServerTick(MinecraftServer server) {
        class_3218 world = server.method_3847(class_1937.field_25179);
        if (world != null) {
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            for (Leaderboard leaderboard : leaderboardData.getLeaderboards()) {
                LeaderboardCommand.updateLeaderboard((class_1937)world, leaderboard);
            }
        }
    }

    public static void onEntityJoin(class_1531 armorStand, class_3218 world) {
        if (leaderboardData == null) {
            leaderboardData = LeaderboardData.load(world);
        }
        class_2338 armorStandPos = armorStand.method_24515();
        leaderboardData.getLeaderboards().forEach(leaderboard -> {
            if (leaderboard.getPosition().equals((Object)armorStandPos)) {
                leaderboard.addArmorStand(armorStand);
            }
        });
    }

    private static void updateLeaderboard(class_1937 world, Leaderboard leaderboard) {
        Map<String, Double> balances = BalanceManager.loadBalances(world.method_8503());
        List sortedBalances = balances.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(leaderboard.getSize()).collect(Collectors.toList());
        ArrayList<CallSite> leaderboardLines = new ArrayList<CallSite>();
        int i = 1;
        for (Map.Entry entry : sortedBalances) {
            try {
                UUID playerUUID = UUID.fromString((String)entry.getKey());
                Optional profile = world.method_8503().method_3793().method_14512(playerUUID);
                String playerName = profile.map(GameProfile::getName).orElse("Unknown Player");
                leaderboardLines.add((CallSite)((Object)(i + ". " + playerName + ": " + String.format("%.2f", entry.getValue()))));
                ++i;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid UUID string: " + (String)entry.getKey());
            }
        }
        leaderboard.getArmorStands().forEach(armorStand -> {
            if (armorStand != null && !armorStand.method_31481()) {
                armorStand.method_5768();
            }
        });
        leaderboard.clearArmorStands();
        class_2338 position = leaderboard.getPosition();
        for (int j = 0; j < leaderboardLines.size(); ++j) {
            String line = (String)leaderboardLines.get(j);
            class_1531 armorStand2 = new class_1531(world, (double)position.method_10263(), (double)position.method_10264() - (double)j * 0.25, (double)position.method_10260());
            armorStand2.method_5648(true);
            armorStand2.method_5665((class_2561)class_2561.method_43470((String)line));
            armorStand2.method_5880(true);
            armorStand2.method_5875(true);
            world.method_8649((class_1297)armorStand2);
            leaderboard.addArmorStand(armorStand2);
        }
    }

    private static class LeaderboardData
    extends class_18 {
        private static final String DATA_NAME = "leaderboard_data";
        private final List<Leaderboard> leaderboards = new ArrayList<Leaderboard>();

        private LeaderboardData() {
        }

        public List<Leaderboard> getLeaderboards() {
            return this.leaderboards;
        }

        public void addLeaderboard(Leaderboard leaderboard) {
            this.leaderboards.add(leaderboard);
        }

        public void removeLeaderboard(Leaderboard leaderboard) {
            this.leaderboards.remove(leaderboard);
        }

        public class_2487 method_75(class_2487 compound, class_7225.class_7874 registryLookup) {
            class_2499 tags = new class_2499();
            this.leaderboards.stream().map(Leaderboard::toTag).forEach(arg_0 -> tags.add(arg_0));
            compound.method_10566("leaderboards", (class_2520)tags);
            return compound;
        }

        public static LeaderboardData fromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
            LeaderboardData data = new LeaderboardData();
            if (nbt.method_10573("leaderboards", 9)) {
                class_2499 tags = nbt.method_10554("leaderboards", 10);
                tags.forEach(tag -> data.addLeaderboard(Leaderboard.fromTag((class_2487)tag)));
            }
            return data;
        }

        public static LeaderboardData load(class_3218 world) {
            return (LeaderboardData)world.method_17983().method_17924(new class_18.class_8645(LeaderboardData::new, LeaderboardData::fromNbt, class_4284.field_19212), DATA_NAME);
        }
    }

    private static class Leaderboard {
        private final class_2338 position;
        private final int size;
        private final List<class_1531> armorStands;

        public Leaderboard(class_2338 position, int size) {
            this.position = position;
            this.size = size;
            this.armorStands = new ArrayList<class_1531>();
        }

        public class_2338 getPosition() {
            return this.position;
        }

        public int getSize() {
            return this.size;
        }

        public List<class_1531> getArmorStands() {
            return this.armorStands;
        }

        public void addArmorStand(class_1531 armorStand) {
            this.armorStands.add(armorStand);
        }

        public void clearArmorStands() {
            this.armorStands.clear();
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10569("x", this.position.method_10263());
            tag.method_10569("y", this.position.method_10264());
            tag.method_10569("z", this.position.method_10260());
            tag.method_10569("size", this.size);
            return tag;
        }

        public static Leaderboard fromTag(class_2487 tag) {
            class_2338 pos = new class_2338(tag.method_10550("x"), tag.method_10550("y"), tag.method_10550("z"));
            int size = tag.method_10550("size");
            return new Leaderboard(pos, size);
        }
    }
}

