/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class BalanceData
extends class_18 {
    private static final String DATA_NAME = "sarosmoneymod_balance";
    private final Map<String, Double> balances = new HashMap<String, Double>();

    public static BalanceData load(class_2487 compound) {
        BalanceData data = new BalanceData();
        if (compound.method_10573("balances", 10)) {
            class_2487 mapTag = compound.method_10562("balances");
            for (String key : mapTag.method_10541()) {
                if (mapTag.method_10573(key, 6)) {
                    data.balances.put(key, mapTag.method_10574(key));
                    continue;
                }
                data.balances.put(key, Double.valueOf(mapTag.method_10550(key)));
            }
        }
        return data;
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 registryLookup) {
        class_2487 mapTag = new class_2487();
        for (Map.Entry<String, Double> entry : this.balances.entrySet()) {
            mapTag.method_10549(entry.getKey(), entry.getValue().doubleValue());
        }
        compound.method_10566("balances", (class_2520)mapTag);
        return compound;
    }

    public static BalanceData fromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        BalanceData data = new BalanceData();
        if (nbt.method_10573("balances", 10)) {
            class_2487 mapTag = nbt.method_10562("balances");
            for (String key : mapTag.method_10541()) {
                if (mapTag.method_10573(key, 6)) {
                    data.balances.put(key, mapTag.method_10574(key));
                    continue;
                }
                data.balances.put(key, Double.valueOf(mapTag.method_10550(key)));
            }
        }
        return data;
    }

    public double getBalance(String playerUUID) {
        return this.balances.getOrDefault(playerUUID, 0.0);
    }

    public boolean containsBalance(String playerUUID) {
        return this.balances.containsKey(playerUUID);
    }

    public void setBalance(String playerUUID, double balance) {
        this.balances.put(playerUUID, balance);
        this.method_80();
    }

    public Map<String, Double> getBalances() {
        return new HashMap<String, Double>(this.balances);
    }

    public static BalanceData get(MinecraftServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Server instance is null");
        }
        class_3218 world = server.method_30002();
        class_26 persistentStateManager = world.method_17983();
        return (BalanceData)persistentStateManager.method_17924(new class_18.class_8645(BalanceData::new, BalanceData::fromNbt, class_4284.field_19212), DATA_NAME);
    }
}

