/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import de.sarocesch.sarosmoneymod.data.BalanceData;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.server.MinecraftServer;

public class BalanceManager {
    private static MinecraftServer currentServer;

    public static void setCurrentServer(MinecraftServer server) {
        currentServer = server;
    }

    public static void addMoneyToPlayer(MinecraftServer server, String playerUUID, double amount) {
        double current = BalanceManager.getBalance(playerUUID);
        BalanceManager.setBalance(playerUUID, current + amount);
    }

    public static Map<String, Double> loadBalances(MinecraftServer server) {
        if (server == null) {
            return Map.of();
        }
        return BalanceManager.getOrCreateBalanceData(server).getBalances();
    }

    public static double getPlayerBalance(class_3222 player) {
        return BalanceManager.getBalance(player.method_5667().toString());
    }

    public static void updatePlayerBalance(class_3222 player, double newBalance) {
        BalanceManager.setBalance(player.method_5667().toString(), newBalance);
    }

    public static double getBalance(String playerUUID) {
        MinecraftServer server = currentServer;
        if (server == null) {
            return 0.0;
        }
        BalanceData data = BalanceManager.getOrCreateBalanceData(server);
        return data.getBalance(playerUUID);
    }

    public static void setBalance(String playerUUID, double balance) {
        MinecraftServer server = currentServer;
        if (server == null) {
            return;
        }
        BalanceData data = BalanceManager.getOrCreateBalanceData(server);
        data.setBalance(playerUUID, balance);
    }

    private static BalanceData getOrCreateBalanceData(MinecraftServer server) {
        return (BalanceData)server.method_30002().method_17983().method_17924(new class_18.class_8645(BalanceData::new, BalanceData::fromNbt, class_4284.field_19212), "balance_data");
    }
}

