/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class BalanceMigrator {
    private static boolean migrated = false;

    public static void migrateOldData(MinecraftServer server) {
        File[] remainingFiles;
        if (migrated) {
            return;
        }
        class_3218 level = server.method_30002();
        Path worldDir = server.method_27050(class_5218.field_24188);
        File oldBankDir = new File(worldDir.toFile(), "bank-account");
        if (!oldBankDir.exists() || !oldBankDir.isDirectory()) {
            migrated = true;
            return;
        }
        File[] bankFiles = oldBankDir.listFiles((dir, name) -> name.endsWith(".bank"));
        if (bankFiles != null) {
            for (File file : bankFiles) {
                String fileName = file.getName();
                String playerUUID = fileName.substring(0, fileName.lastIndexOf(".bank"));
                try {
                    String content = new String(Files.readAllBytes(file.toPath())).trim();
                    double balance = Double.parseDouble(content);
                    if (content.indexOf(46) == -1) {
                        balance = Integer.parseInt(content);
                    }
                    BalanceManager.setBalance(playerUUID, balance);
                    Files.delete(file.toPath());
                }
                catch (IOException | NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((remainingFiles = oldBankDir.listFiles()) == null || remainingFiles.length == 0) {
            try {
                Files.delete(oldBankDir.toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        migrated = true;
        System.out.println("[SarosMoneyMod] Old bank data has been migrated.");
    }
}

