/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import de.sarocesch.sarosmoneymod.handlers.ContainerHandler;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_8242;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ServerHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handleSignUpdate(@Nullable class_3222 player, class_2338 signPos) {
        class_2586 class_25862;
        class_1937 world;
        class_1937 class_19372 = world = player != null ? player.method_37908() : null;
        if (world == null) {
            LOGGER.warn("[Shop] Cannot process sign update: invalid world");
            return;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_8402(signPos.method_10263() >> 4, signPos.method_10260() >> 4, class_2806.field_12803, true);
        }
        if ((class_25862 = world.method_8321(signPos)) instanceof class_2625) {
            class_5250 itemName;
            boolean updated;
            class_2625 sign = (class_2625)class_25862;
            sign.method_5431();
            class_2680 signState = world.method_8320(signPos);
            class_2338 containerPos = ContainerHandler.getAttachedContainerPos(world, signPos, signState);
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_8402(containerPos.method_10263() >> 4, containerPos.method_10260() >> 4, class_2806.field_12803, true);
                class_2586 containerEntity = world.method_8321(containerPos);
                if (containerEntity != null) {
                    containerEntity.method_5431();
                }
            }
            if (updated = ServerHandler.updateSignText(sign, containerPos, itemName = ServerHandler.getItemName(world, containerPos))) {
                ServerHandler.syncSignWithClient(world, signPos, sign);
                if (world.method_8503() != null) {
                    world.method_8503().execute(() -> {
                        ServerHandler.syncSignWithClient(world, signPos, sign);
                        world.method_8413(signPos, signState, signState, 3);
                    });
                }
            }
        }
    }

    private static boolean updateSignText(class_2625 sign, class_2338 containerPos, class_5250 itemName) {
        class_8242 frontText = sign.method_49853();
        class_2561[] lines = frontText.method_49877(true);
        String firstLine = ServerHandler.stripFormatting(lines[0]).trim().toLowerCase();
        boolean isShop = firstLine.equals("[shop]");
        boolean isBuy = firstLine.equals("[buy]");
        boolean isSell = firstLine.equals("[sell]");
        if (!(isShop || isBuy || isSell)) {
            return false;
        }
        class_124 color = isBuy ? class_124.field_1078 : (isSell ? class_124.field_1065 : class_124.field_1077);
        class_2561[] newLines = new class_2561[4];
        newLines[0] = class_2561.method_43470((String)(isShop ? "[SHOP]" : (isBuy ? "[BUY]" : "[SELL]"))).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(color));
        newLines[1] = lines[1].method_27661();
        newLines[2] = itemName;
        try {
            String priceText = ServerHandler.stripFormatting(lines[3]).replaceAll("[^\\d.,]", "").replace(',', '.');
            if (priceText.isEmpty()) {
                throw new NumberFormatException("Empty price");
            }
            double price = Double.parseDouble(priceText);
            newLines[3] = class_2561.method_43470((String)("$" + String.format("%.2f", price))).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(color));
        }
        catch (Exception e) {
            LOGGER.error("Invalid price format: {}", (Object)e.getMessage());
            newLines[3] = class_2561.method_43470((String)"Invalid Price").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
        }
        if (itemName.getString().isEmpty()) {
            LOGGER.error("[Shop Error] Missing item in container at {}", (Object)containerPos);
            newLines[2] = class_2561.method_43470((String)"!NO ITEM!").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
        }
        class_8242 newSignText = new class_8242(newLines, newLines, frontText.method_49872(), frontText.method_49856());
        sign.method_49840(newSignText, true);
        sign.method_49840(newSignText, false);
        sign.method_5431();
        if (sign.method_10997() != null) {
            sign.method_10997().method_22350(sign.method_11016()).method_12008(true);
        }
        return true;
    }

    private static void syncSignWithClient(class_1937 world, class_2338 pos, class_2625 sign) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_2622 packet = class_2622.method_38585((class_2586)sign);
        serverWorld.method_14178().field_17254.method_17210(serverWorld.method_22350(pos).method_12004(), false).forEach(player -> player.field_13987.method_14364((class_2596)packet));
        class_2680 state = world.method_8320(pos);
        world.method_8413(pos, state, state, 3);
    }

    private static class_5250 getItemName(class_1937 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof class_1263) {
            class_1263 inventory = (class_1263)be;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960()) continue;
                String rawName = ServerHandler.stripFormatting(stack.method_7964());
                return class_2561.method_43470((String)rawName).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
            }
        }
        return class_2561.method_43470((String)"").method_10862(class_2583.field_24360);
    }

    private static String stripFormatting(class_2561 component) {
        return component.getString().replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    private static class_1792 getItemFromContainer(class_2338 containerPos, class_1937 world) {
        class_2586 be = world.method_8321(containerPos);
        if (be instanceof class_1263) {
            class_1263 inventory = (class_1263)be;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960()) continue;
                return stack.method_7909();
            }
        }
        return class_1802.field_8162;
    }
}

