/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.SarosMoneyModMod;
import de.sarocesch.sarosmoneymod.handlers.ServerHandler;
import de.sarocesch.sarosmoneymod.handlers.ShopSignHandler;
import de.sarocesch.sarosmoneymod.network.NetworkHandler;
import de.sarocesch.sarosmoneymod.network.SignUpdatePacket;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_7743;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class SignShopListenerFabric {
    private static final Map<class_2338, Long> recentlyPlacedSigns = new HashMap<class_2338, Long>();
    private static final long SIGN_TRACKING_TIMEOUT = 5000L;
    private static final Map<String, class_2487> SIGN_DATA = new HashMap<String, class_2487>();
    @Environment(value=EnvType.CLIENT)
    private static Field signField;

    @Environment(value=EnvType.CLIENT)
    private static void initSignField() {
        try {
            signField = class_7743.class.getDeclaredField("blockEntity");
            signField.setAccessible(true);
        }
        catch (Exception e) {
            SarosMoneyModMod.LOGGER.error("Failed to find sign field:", (Throwable)e);
        }
    }

    public static void register() {
        AttackBlockCallback.EVENT.register(SignShopListenerFabric::onBlockBreak);
        UseBlockCallback.EVENT.register(SignShopListenerFabric::onRightClickBlock);
        ServerTickEvents.END_SERVER_TICK.register(server -> SignShopListenerFabric.checkForNewSigns(server));
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (world instanceof class_3218) {
                    // empty if block
                }
            }
        });
        SarosMoneyModMod.LOGGER.info("Registered SignShopListener events for Fabric");
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientEvents() {
        SignShopListenerFabric.initSignField();
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_7743) {
                ScreenEvents.remove((class_437)screen).register(screen1 -> SignShopListenerFabric.onSignClose(screen1));
            }
        });
    }

    private static class_1269 onBlockBreak(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        UUID ownerUUID;
        class_2487 persistentData;
        class_2625 sign;
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof class_1263 && (sign = SignShopListenerFabric.findLinkedSign(world, pos)) != null && (persistentData = SignShopListenerFabric.getPersistentData(sign)).method_10545("OwnerUUID")) {
            ownerUUID = UUID.fromString(persistentData.method_10558("OwnerUUID"));
            if (!player.method_5667().equals(ownerUUID) && !player.method_7337()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"shop.protection.container_owner_only").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true))), true);
                return class_1269.field_5814;
            }
        }
        if (blockEntity instanceof class_2625 && (persistentData = SignShopListenerFabric.getPersistentData(sign = (class_2625)blockEntity)).method_10545("OwnerUUID")) {
            ownerUUID = UUID.fromString(persistentData.method_10558("OwnerUUID"));
            if (!player.method_5667().equals(ownerUUID) && !player.method_7337()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"shop.protection.sign_owner_only").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true))), true);
                return class_1269.field_5814;
            }
        }
        return class_1269.field_5811;
    }

    private static class_1269 onRightClickBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        class_2487 persistentData;
        class_2625 sign;
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        class_2338 pos = hitResult.method_17777();
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof class_1263 && (sign = SignShopListenerFabric.findLinkedSign(world, pos)) != null && (persistentData = SignShopListenerFabric.getPersistentData(sign)).method_10545("OwnerUUID")) {
            UUID ownerUUID = UUID.fromString(persistentData.method_10558("OwnerUUID"));
            if (!player.method_5667().equals(ownerUUID) && !player.method_7337()) {
                boolean isShopInteraction;
                boolean bl = isShopInteraction = player.method_6047().method_7960() && SignShopListenerFabric.isShopSign(sign.method_49853().method_49859(0, false).getString());
                if (!isShopInteraction) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"shop.protection.container_owner_only").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true))), true);
                    return class_1269.field_5814;
                }
            }
        }
        if (blockEntity instanceof class_2625) {
            sign = (class_2625)blockEntity;
            class_2561[] lines = new class_2561[4];
            for (int i = 0; i < 4; ++i) {
                lines[i] = sign.method_49853().method_49859(i, false);
            }
            String[] signContent = new String[4];
            for (int i = 0; i < 4; ++i) {
                signContent[i] = SignShopListenerFabric.stripFormatting(lines[i]).trim();
            }
            String firstLine = signContent[0].toLowerCase();
            if (!firstLine.matches("\\[?(buy|sell|shop)\\]?")) {
                return class_1269.field_5811;
            }
            class_2487 persistentData2 = SignShopListenerFabric.getPersistentData(sign);
            UUID ownerUUID = persistentData2.method_10545("OwnerUUID") ? UUID.fromString(persistentData2.method_10558("OwnerUUID")) : null;
            try {
                String type = "";
                String itemId = "";
                String priceStr = "";
                if (firstLine.equals("[shop]")) {
                    type = signContent[1].toLowerCase();
                    itemId = signContent[2];
                    priceStr = signContent[3];
                } else {
                    type = firstLine.replaceAll("[\\[\\]]", "").toLowerCase();
                    if (signContent[1].isEmpty()) {
                        itemId = signContent[2];
                        priceStr = signContent[3];
                    } else {
                        itemId = signContent[1];
                        priceStr = signContent[2];
                    }
                }
                if (itemId.isEmpty() || priceStr.isEmpty()) {
                    throw new IllegalArgumentException("Missing item or price");
                }
                double price = Double.parseDouble(priceStr.replaceAll("[^\\d.,]", "").replace(",", "."));
                try {
                    class_1792 item = null;
                    String searchName = itemId.toLowerCase();
                    if (searchName.contains(":")) {
                        searchName = searchName.split(":", 2)[1];
                    }
                    if (searchName.equals("grass block")) {
                        item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"minecraft", (String)"grass_block"));
                    } else if (searchName.equals("stone")) {
                        item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"minecraft", (String)"stone"));
                    } else {
                        String itemName;
                        for (class_1792 registeredItem : class_7923.field_41178) {
                            itemName = registeredItem.method_7848().getString().toLowerCase();
                            if (!itemName.equals(searchName) && !itemName.replace(" ", "_").equals(searchName)) continue;
                            item = registeredItem;
                            break;
                        }
                        if (item == null) {
                            for (class_1792 registeredItem : class_7923.field_41178) {
                                itemName = registeredItem.method_7848().getString().toLowerCase();
                                if (!itemName.contains(searchName) && !itemName.replace(" ", "_").contains(searchName)) continue;
                                item = registeredItem;
                                break;
                            }
                        }
                    }
                    if (item == null) {
                        throw new IllegalArgumentException("Item not found: " + itemId);
                    }
                    ShopSignHandler.handleSignInteraction(ownerUUID, player, item.method_7848().getString(), price, type, pos);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                return class_1269.field_5812;
            }
            catch (Exception e) {
                SarosMoneyModMod.LOGGER.error("[Shop Error] Interaction failed: {}", (Object)e.getMessage());
                player.method_7353((class_2561)class_2561.method_43470((String)("Shop Error: " + e.getMessage())).method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), true);
            }
        }
        return class_1269.field_5811;
    }

    private static void checkForNewSigns(MinecraftServer server) {
        long currentTime = System.currentTimeMillis();
        recentlyPlacedSigns.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 5000L);
        for (class_3218 world : server.method_3738()) {
            for (class_3222 player : world.method_18456()) {
                class_2338 playerPos = player.method_24515();
                for (class_2338 pos : class_2338.method_10097((class_2338)playerPos.method_10069(-5, -5, -5), (class_2338)playerPos.method_10069(5, 5, 5))) {
                    class_2625 sign;
                    class_2487 persistentData;
                    class_2586 blockEntity;
                    if (recentlyPlacedSigns.containsKey(pos) || !((blockEntity = world.method_8321(pos)) instanceof class_2625) || (persistentData = SignShopListenerFabric.getPersistentData(sign = (class_2625)blockEntity)).method_10545("OwnerUUID")) continue;
                    recentlyPlacedSigns.put(pos.method_10062(), currentTime);
                    SignShopListenerFabric.processNewSign((class_1657)player, (class_1937)world, pos, sign);
                }
            }
        }
    }

    private static void processNewSign(class_1657 player, class_1937 world, class_2338 signPos, class_2625 sign) {
        if (world.method_8608()) {
            return;
        }
        class_2487 persistentData = SignShopListenerFabric.getPersistentData(sign);
        persistentData.method_10582("OwnerUUID", player.method_5667().toString());
        SignShopListenerFabric.setPersistentData(sign, persistentData);
        sign.method_5431();
        world.method_8413(signPos, world.method_8320(signPos), world.method_8320(signPos), 3);
        class_2680 signState = world.method_8320(signPos);
        class_2350 facing = class_2350.field_11043;
        if (signState.method_28498((class_2769)class_2741.field_12481)) {
            facing = (class_2350)signState.method_11654((class_2769)class_2741.field_12481);
        } else if (signState.method_28498((class_2769)class_2741.field_12532)) {
            int rotation = (Integer)signState.method_11654((class_2769)class_2741.field_12532);
            facing = class_2350.method_10139((int)(rotation / 4));
        }
        class_2338 containerPos = signPos.method_10093(facing.method_10153());
        persistentData.method_10539("ContainerPos", new int[]{containerPos.method_10263(), containerPos.method_10264(), containerPos.method_10260()});
        SignShopListenerFabric.setPersistentData(sign, persistentData);
        sign.method_5431();
        world.method_8413(signPos, world.method_8320(signPos), world.method_8320(signPos), 3);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ServerHandler.handleSignUpdate(serverPlayer, signPos);
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_8503().execute(() -> ServerHandler.handleSignUpdate(serverPlayer, signPos));
                serverWorld.method_8503().execute(() -> {
                    try {
                        Thread.sleep(250L);
                        ServerHandler.handleSignUpdate(serverPlayer, signPos);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
                serverWorld.method_8503().execute(() -> {
                    try {
                        Thread.sleep(500L);
                        ServerHandler.handleSignUpdate(serverPlayer, signPos);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void onSignClose(class_437 screen) {
        if (screen instanceof class_7743) {
            class_310.method_1551().execute(() -> {
                try {
                    if (signField == null) {
                        SignShopListenerFabric.initSignField();
                    }
                    class_2625 sign = (class_2625)signField.get(screen);
                    sign.method_5431();
                    class_1937 world = sign.method_10997();
                    if (world != null) {
                        world.method_8413(sign.method_11016(), world.method_8320(sign.method_11016()), world.method_8320(sign.method_11016()), 3);
                    }
                    NetworkHandler.sendToServer(new SignUpdatePacket(sign.method_11016()));
                }
                catch (Exception e) {
                    SarosMoneyModMod.LOGGER.error("Sign update failed", (Throwable)e);
                }
            });
        }
    }

    private static class_2625 findLinkedSign(class_1937 world, class_2338 containerPos) {
        for (class_2338 pos : class_2338.method_10097((class_2338)containerPos.method_10069(-5, -5, -5), (class_2338)containerPos.method_10069(5, 5, 5))) {
            int[] coords;
            class_2338 linkedPos;
            class_2625 sign;
            class_2487 persistentData;
            class_2586 blockEntity = world.method_8321(pos);
            if (!(blockEntity instanceof class_2625) || !(persistentData = SignShopListenerFabric.getPersistentData(sign = (class_2625)blockEntity)).method_10545("ContainerPos") || !(linkedPos = new class_2338((coords = persistentData.method_10561("ContainerPos"))[0], coords[1], coords[2])).equals((Object)containerPos)) continue;
            return sign;
        }
        return null;
    }

    private static String stripFormatting(class_2561 component) {
        return component.getString().replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    private static boolean isShopSign(String firstLine) {
        String line = SignShopListenerFabric.stripFormatting((class_2561)class_2561.method_43470((String)firstLine)).trim().toLowerCase();
        return line.contains("[shop]") || line.contains("[buy]") || line.contains("[sell]");
    }

    private static class_2487 getPersistentData(class_2625 sign) {
        class_2487 customData = new class_2487();
        class_2338 pos = sign.method_11016();
        String key = pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260();
        if (SIGN_DATA.containsKey(key)) {
            return SIGN_DATA.get(key);
        }
        return customData;
    }

    private static void setPersistentData(class_2625 sign, class_2487 data) {
        class_2338 pos = sign.method_11016();
        String key = pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260();
        SIGN_DATA.put(key, data);
    }
}

