/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.procedures;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.init.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_342;

public class WithdrawProcedure {
    public static void execute(class_1297 entity, HashMap guistate, String withdrawValue, class_3222 player) {
        class_1657 _player;
        if (entity == null || guistate == null) {
            return;
        }
        if (entity instanceof class_1657 && !(_player = (class_1657)entity).method_37908().method_8608()) {
            try {
                int amount = Integer.parseInt(withdrawValue);
                if (amount > 0) {
                    String playerUUID = _player.method_5667().toString();
                    double currentBalance = BalanceManager.getBalance(playerUUID);
                    if ((double)amount <= currentBalance) {
                        Map<Integer, class_1799> items = WithdrawProcedure.convertAmountToItems(amount);
                        boolean canFitAllItems = WithdrawProcedure.canFitItems(_player, items);
                        if (canFitAllItems) {
                            WithdrawProcedure.addItemsToPlayerInventory(_player, items);
                            double newBalance = currentBalance - (double)amount;
                            BalanceManager.setBalance(playerUUID, newBalance);
                            _player.method_7353((class_2561)class_2561.method_43470((String)("\u00a79" + class_2561.method_43471((String)"lang.withdraw.previous_balance").getString() + " " + currentBalance)), false);
                            _player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a" + class_2561.method_43471((String)"lang.withdraw.withdrawn_amount").getString() + " " + amount)), false);
                            _player.method_7353((class_2561)class_2561.method_43470((String)("\u00a76" + class_2561.method_43471((String)"lang.withdraw.new_balance").getString() + " " + newBalance)), false);
                            ((class_342)guistate.get("text:withdraw")).method_1852("");
                        } else {
                            _player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c" + class_2561.method_43471((String)"lang.withdraw.not_enough_inventory").getString())), false);
                        }
                    } else {
                        _player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c" + class_2561.method_43471((String)"lang.withdraw.not_enough_balance").getString())), false);
                    }
                } else {
                    _player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c" + class_2561.method_43471((String)"lang.withdraw.enter_positive_number").getString())), false);
                }
            }
            catch (NumberFormatException e) {
                _player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c" + class_2561.method_43471((String)"lang.withdraw.enter_valid_number").getString())), false);
            }
        }
    }

    private static Map<Integer, class_1799> convertAmountToItems(int amount) {
        HashMap<Integer, class_1799> items = new HashMap<Integer, class_1799>();
        int remaining = amount;
        int[] denominations = new int[]{500, 200, 100, 50, 20, 10, 5, 2, 1};
        class_1799[] itemStacks = new class_1799[]{new class_1799((class_1935)ModItems.EURO_500), new class_1799((class_1935)ModItems.EURO_200), new class_1799((class_1935)ModItems.EURO_100), new class_1799((class_1935)ModItems.EURO_50), new class_1799((class_1935)ModItems.EURO_20), new class_1799((class_1935)ModItems.EURO_10), new class_1799((class_1935)ModItems.EURO_5), new class_1799((class_1935)ModItems.EURO_2), new class_1799((class_1935)ModItems.EURO_1)};
        for (int i = 0; i < denominations.length; ++i) {
            int denom = denominations[i];
            int count = remaining / denom;
            if (count <= 0) continue;
            class_1799 stack = itemStacks[i].method_7972();
            stack.method_7939(count);
            items.put(denom, stack);
            remaining %= denom;
        }
        return items;
    }

    private static boolean canFitItems(class_1657 player, Map<Integer, class_1799> items) {
        int freeSlots = 0;
        int slotsNeeded = 0;
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            if (!((class_1799)player.method_31548().field_7547.get(i)).method_7960()) continue;
            ++freeSlots;
        }
        for (class_1799 stack : items.values()) {
            int remainingCount = stack.method_7947();
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                int spaceInStack;
                class_1799 invStack = (class_1799)player.method_31548().field_7547.get(i);
                if (invStack.method_7960() || !class_1799.method_31577((class_1799)invStack, (class_1799)stack) || (remainingCount -= (spaceInStack = invStack.method_7914() - invStack.method_7947())) > 0) continue;
                remainingCount = 0;
                break;
            }
            slotsNeeded += (remainingCount + stack.method_7914() - 1) / stack.method_7914();
        }
        return freeSlots >= slotsNeeded;
    }

    private static void addItemsToPlayerInventory(class_1657 player, Map<Integer, class_1799> items) {
        for (class_1799 stack : items.values()) {
            while (!stack.method_7960()) {
                int remainingCount = stack.method_7947();
                for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                    class_1799 invStack = (class_1799)player.method_31548().field_7547.get(i);
                    if (invStack.method_7960() || !class_1799.method_31577((class_1799)invStack, (class_1799)stack)) continue;
                    int spaceInStack = invStack.method_7914() - invStack.method_7947();
                    if (remainingCount <= spaceInStack) {
                        invStack.method_7933(remainingCount);
                        stack.method_7939(0);
                        break;
                    }
                    invStack.method_7933(spaceInStack);
                    remainingCount -= spaceInStack;
                }
                if (stack.method_7960()) continue;
                player.method_7270(stack.method_7971(stack.method_7914()));
            }
        }
    }
}

