/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import de.sarocesch.sarosmoneymod.SarosMoneyModMod;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="saros__money_mod")
public class SignAttachmentType {
    public static final Capability<SignData> SIGN_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<SignData>(){});
    public static final SignData SIGN_DATA = new SignData();

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(SignData.class);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<SignBlockEntity> event) {
        SignBlockEntity sign = (SignBlockEntity)event.getObject();
        LazyOptional existing = sign.getCapability(SIGN_DATA_CAPABILITY);
        if (!existing.isPresent()) {
            SignDataProvider provider = new SignDataProvider();
            event.addCapability(new ResourceLocation("saros__money_mod", "sign_data"), (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
        }
    }

    public static SignData getData(SignBlockEntity sign) {
        return (SignData)sign.getCapability(SIGN_DATA_CAPABILITY).orElseGet(() -> {
            SignData data = new SignData();
            try {
                Field persistentDataField = SignBlockEntity.class.getDeclaredField("persistentData");
                persistentDataField.setAccessible(true);
                CompoundTag nbt = (CompoundTag)persistentDataField.get(sign);
                if (nbt.hasUUID("OwnerUUID")) {
                    data.setOwnerUUID(nbt.getUUID("OwnerUUID"));
                }
                if (nbt.contains("ShopType")) {
                    data.setShopType(nbt.getString("ShopType"));
                }
                if (nbt.contains("ItemId")) {
                    data.setItemId(nbt.getString("ItemId"));
                }
                if (nbt.contains("Price")) {
                    data.setPrice(nbt.getInt("Price"));
                }
                if (nbt.contains("Amount")) {
                    data.setAmount(nbt.getInt("Amount"));
                }
            }
            catch (Exception e) {
                SarosMoneyModMod.LOGGER.error("Failed to get sign data from NBT", (Throwable)e);
            }
            return data;
        });
    }

    public static class SignData
    implements INBTSerializable<CompoundTag> {
        private UUID ownerUUID = null;
        private String shopType = "";
        private String itemId = "";
        private int price = 0;
        private int amount = 0;

        public UUID getOwnerUUID() {
            return this.ownerUUID;
        }

        public void setOwnerUUID(UUID ownerUUID) {
            this.ownerUUID = ownerUUID;
        }

        public String getShopType() {
            return this.shopType;
        }

        public void setShopType(String shopType) {
            this.shopType = shopType;
        }

        public String getItemId() {
            return this.itemId;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public int getPrice() {
            return this.price;
        }

        public void setPrice(int price) {
            this.price = price;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.ownerUUID != null) {
                tag.putUUID("OwnerUUID", this.ownerUUID);
            }
            tag.putString("ShopType", this.shopType);
            tag.putString("ItemId", this.itemId);
            tag.putInt("Price", this.price);
            tag.putInt("Amount", this.amount);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.hasUUID("OwnerUUID")) {
                this.ownerUUID = tag.getUUID("OwnerUUID");
            }
            this.shopType = tag.getString("ShopType");
            this.itemId = tag.getString("ItemId");
            this.price = tag.getInt("Price");
            this.amount = tag.getInt("Amount");
        }
    }

    public static class SignDataProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final SignData data = new SignData();
        private final LazyOptional<SignData> dataOptional = LazyOptional.of(() -> this.data);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return SIGN_DATA_CAPABILITY.orEmpty(cap, this.dataOptional);
        }

        public CompoundTag serializeNBT() {
            return this.data.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.data.deserializeNBT(nbt);
        }

        public void invalidate() {
            this.dataOptional.invalidate();
        }
    }
}

