/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.world.inventory;

import de.sarocesch.sarosmoneymod.ModDataComponents;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModMenus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class WalletGUIMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private boolean boundToItem = false;
    private int boundHand = -1;
    private static final TagKey<Item> SAROS_MONEY = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"forge:sarosmoney"));

    public WalletGUIMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)SarosMoneyModModMenus.WALLET_GUI.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.internal = new ItemStackHandler(18);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                byte hand = extraData.readByte();
                ItemStack itemstack = hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem();
                this.bound = true;
                this.boundToItem = true;
                this.boundHand = hand;
                ItemStackHandler handler = new ItemStackHandler(this, 18){

                    protected void onContentsChanged(int slot) {
                    }
                };
                ItemContainerContents contents = (ItemContainerContents)itemstack.get((DataComponentType)ModDataComponents.WALLET_ITEMS.get());
                if (contents != null) {
                    NonNullList saved = NonNullList.withSize((int)handler.getSlots(), (Object)ItemStack.EMPTY);
                    contents.copyInto(saved);
                    int slots = Math.min(saved.size(), handler.getSlots());
                    for (int i = 0; i < slots; ++i) {
                        ItemStack s = (ItemStack)saved.get(i);
                        if (s.isEmpty()) continue;
                        handler.setStackInSlot(i, s.copy());
                    }
                }
                this.internal = handler;
            } else if (extraData.readableBytes() > 1) {
                extraData.readByte();
                Entity entity = this.world.getEntity(extraData.readVarInt());
                if (entity != null) {
                    entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> {
                        this.internal = capability;
                        this.bound = true;
                    });
                }
            } else {
                BlockEntity ent;
                BlockEntity blockEntity = ent = inv.player != null ? inv.player.level().getBlockEntity(pos) : null;
                if (ent != null) {
                    ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> {
                        this.internal = capability;
                        this.bound = true;
                    });
                }
            }
        }
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 0, 8, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(1, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 1, 26, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(2, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 2, 44, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(3, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 3, 62, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(4, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 4, 80, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(5, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 5, 98, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(6, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 6, 116, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(7, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 7, 134, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(8, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 8, 152, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(9, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 9, 8, 25){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(10, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 10, 26, 25){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(11, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 11, 44, 25){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(12, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 12, 62, 25){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(13, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 13, 80, 25){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(14, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 14, 98, 25){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(15, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 15, 116, 25){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(16, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 16, 134, 25){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        this.customSlots.put(17, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 17, 152, 25){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SAROS_MONEY);
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 83 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 8 + si * 18, 141));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 18) {
                if (!this.moveItemStackTo(itemstack1, 18, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 18, false)) {
                if (index < 45 ? !this.moveItemStackTo(itemstack1, 45, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 18, 45, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && !(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (maxSize = Math.min(slot.getMaxStackSize(), p_38904_.getMaxStackSize()))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        p_38904_.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (!(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    if (p_38904_.getCount() > slot1.getMaxStackSize()) {
                        slot1.set(p_38904_.split(slot1.getMaxStackSize()));
                    } else {
                        slot1.set(p_38904_.split(p_38904_.getCount()));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (!this.bound && playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    playerIn.drop(this.internal.extractItem(j, this.internal.getStackInSlot(j).getCount(), false), false);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    playerIn.getInventory().placeItemBackInInventory(this.internal.extractItem(i, this.internal.getStackInSlot(i).getCount(), false));
                }
            }
            return;
        }
        if (this.bound && this.boundToItem && playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            ItemStack stackInHand = this.boundHand == 0 ? serverPlayer.getMainHandItem() : serverPlayer.getOffhandItem();
            NonNullList saveList = NonNullList.withSize((int)this.internal.getSlots(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < this.internal.getSlots(); ++i) {
                ItemStack s = this.internal.getStackInSlot(i);
                if (!s.isEmpty() && !s.is(SAROS_MONEY)) {
                    serverPlayer.getInventory().placeItemBackInInventory(s.copy());
                    saveList.set(i, (Object)ItemStack.EMPTY);
                    continue;
                }
                saveList.set(i, (Object)s.copy());
            }
            ItemContainerContents contents = ItemContainerContents.fromItems((List)saveList);
            stackInHand.set((DataComponentType)ModDataComponents.WALLET_ITEMS.get(), (Object)contents);
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

