/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final Logger LOGGER = LogManager.getLogger(Config.class);
    public static boolean CHESTSHOP_ENABLED = true;
    public static int START_MONEY = 100;
    public static int MONEY_LOSS_ON_DEATH = 0;
    public static boolean PAYCHECK_ENABLED = false;
    public static int PAYCHECK_AMOUNT = 50;
    public static boolean VILLAGER_TRADES_ENABLED = true;
    public static int TRADE_L1_RAW_IRON_AMOUNT = 5;
    public static int TRADE_L2_DIAMOND_AMOUNT = 3;
    public static int TRADE_L3_RAW_COPPER_AMOUNT = 5;
    public static int TRADE_L4_RAW_IRON_AMOUNT = 3;
    public static int TRADE_L4_DIAMOND_AMOUNT = 2;
    public static int TRADE_L5_GOLDEN_APPLE_AMOUNT = 1;
    public static int TRADE_L5_NETHER_STAR_AMOUNT = 1;
    public static int TRADE_L1_EURO_AMOUNT = 1;
    public static int TRADE_L2_EURO_AMOUNT = 1;
    public static int TRADE_L3_EURO_AMOUNT = 1;
    public static int TRADE_L4_RAW_IRON_EURO_AMOUNT = 1;
    public static int TRADE_L4_DIAMOND_EURO_AMOUNT = 1;
    public static int TRADE_L5_GOLDEN_APPLE_EURO_AMOUNT = 1;
    public static int TRADE_L5_NETHER_STAR_EURO_AMOUNT = 1;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        Config.loadConfig();
    }

    public static void loadConfig() {
        File configFile = new File(FMLPaths.GAMEDIR.get().toString() + "/config/", "saros_money_mod.json");
        if (!configFile.exists()) {
            Config.createDefaultConfig(configFile);
        } else {
            try (FileReader reader = new FileReader(configFile);){
                boolean updated;
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                START_MONEY = json.has("startMoney") ? json.get("startMoney").getAsInt() : START_MONEY;
                MONEY_LOSS_ON_DEATH = json.has("moneyLossOnDeath") ? json.get("moneyLossOnDeath").getAsInt() : MONEY_LOSS_ON_DEATH;
                PAYCHECK_ENABLED = json.has("paycheckEnabled") ? json.get("paycheckEnabled").getAsBoolean() : PAYCHECK_ENABLED;
                int n = PAYCHECK_AMOUNT = json.has("paycheckAmount") ? json.get("paycheckAmount").getAsInt() : PAYCHECK_AMOUNT;
                if (json.has("villagerConfig")) {
                    JsonObject villagerConfig = json.getAsJsonObject("villagerConfig");
                    VILLAGER_TRADES_ENABLED = villagerConfig.has("tradesEnabled") ? villagerConfig.get("tradesEnabled").getAsBoolean() : VILLAGER_TRADES_ENABLED;
                    TRADE_L1_RAW_IRON_AMOUNT = villagerConfig.has("tradeL1RawIronAmount") ? villagerConfig.get("tradeL1RawIronAmount").getAsInt() : TRADE_L1_RAW_IRON_AMOUNT;
                    TRADE_L2_DIAMOND_AMOUNT = villagerConfig.has("tradeL2DiamondAmount") ? villagerConfig.get("tradeL2DiamondAmount").getAsInt() : TRADE_L2_DIAMOND_AMOUNT;
                    TRADE_L3_RAW_COPPER_AMOUNT = villagerConfig.has("tradeL3RawCopperAmount") ? villagerConfig.get("tradeL3RawCopperAmount").getAsInt() : TRADE_L3_RAW_COPPER_AMOUNT;
                    TRADE_L4_RAW_IRON_AMOUNT = villagerConfig.has("tradeL4RawIronAmount") ? villagerConfig.get("tradeL4RawIronAmount").getAsInt() : TRADE_L4_RAW_IRON_AMOUNT;
                    TRADE_L4_DIAMOND_AMOUNT = villagerConfig.has("tradeL4DiamondAmount") ? villagerConfig.get("tradeL4DiamondAmount").getAsInt() : TRADE_L4_DIAMOND_AMOUNT;
                    TRADE_L5_GOLDEN_APPLE_AMOUNT = villagerConfig.has("tradeL5GoldenAppleAmount") ? villagerConfig.get("tradeL5GoldenAppleAmount").getAsInt() : TRADE_L5_GOLDEN_APPLE_AMOUNT;
                    TRADE_L5_NETHER_STAR_AMOUNT = villagerConfig.has("tradeL5NetherStarAmount") ? villagerConfig.get("tradeL5NetherStarAmount").getAsInt() : TRADE_L5_NETHER_STAR_AMOUNT;
                    TRADE_L1_EURO_AMOUNT = villagerConfig.has("tradeL1EuroAmount") ? villagerConfig.get("tradeL1EuroAmount").getAsInt() : TRADE_L1_EURO_AMOUNT;
                    TRADE_L2_EURO_AMOUNT = villagerConfig.has("tradeL2EuroAmount") ? villagerConfig.get("tradeL2EuroAmount").getAsInt() : TRADE_L2_EURO_AMOUNT;
                    TRADE_L3_EURO_AMOUNT = villagerConfig.has("tradeL3EuroAmount") ? villagerConfig.get("tradeL3EuroAmount").getAsInt() : TRADE_L3_EURO_AMOUNT;
                    TRADE_L4_RAW_IRON_EURO_AMOUNT = villagerConfig.has("tradeL4RawIronEuroAmount") ? villagerConfig.get("tradeL4RawIronEuroAmount").getAsInt() : TRADE_L4_RAW_IRON_EURO_AMOUNT;
                    TRADE_L4_DIAMOND_EURO_AMOUNT = villagerConfig.has("tradeL4DiamondEuroAmount") ? villagerConfig.get("tradeL4DiamondEuroAmount").getAsInt() : TRADE_L4_DIAMOND_EURO_AMOUNT;
                    TRADE_L5_GOLDEN_APPLE_EURO_AMOUNT = villagerConfig.has("tradeL5GoldenAppleEuroAmount") ? villagerConfig.get("tradeL5GoldenAppleEuroAmount").getAsInt() : TRADE_L5_GOLDEN_APPLE_EURO_AMOUNT;
                    int n2 = TRADE_L5_NETHER_STAR_EURO_AMOUNT = villagerConfig.has("tradeL5NetherStarEuroAmount") ? villagerConfig.get("tradeL5NetherStarEuroAmount").getAsInt() : TRADE_L5_NETHER_STAR_EURO_AMOUNT;
                }
                if (updated = Config.updateConfigIfNeeded(json, configFile)) {
                    LOGGER.info("Config file updated with new fields");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean updateConfigIfNeeded(JsonObject json, File configFile) {
        JsonObject vc;
        boolean changed = false;
        if (!json.has("startMoney")) {
            json.addProperty("startMoney", (Number)START_MONEY);
            changed = true;
        }
        if (!json.has("moneyLossOnDeath")) {
            json.addProperty("moneyLossOnDeath", (Number)MONEY_LOSS_ON_DEATH);
            changed = true;
        }
        if (!json.has("paycheckEnabled")) {
            json.addProperty("paycheckEnabled", Boolean.valueOf(PAYCHECK_ENABLED));
            changed = true;
        }
        if (!json.has("paycheckAmount")) {
            json.addProperty("paycheckAmount", (Number)PAYCHECK_AMOUNT);
            changed = true;
        }
        JsonObject jsonObject = vc = json.has("villagerConfig") ? json.getAsJsonObject("villagerConfig") : new JsonObject();
        if (!json.has("villagerConfig")) {
            json.add("villagerConfig", (JsonElement)vc);
            changed = true;
        }
        if (!vc.has("tradesEnabled")) {
            vc.addProperty("tradesEnabled", Boolean.valueOf(VILLAGER_TRADES_ENABLED));
            changed = true;
        }
        if (!vc.has("tradeL1RawIronAmount")) {
            vc.addProperty("tradeL1RawIronAmount", (Number)TRADE_L1_RAW_IRON_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL2DiamondAmount")) {
            vc.addProperty("tradeL2DiamondAmount", (Number)TRADE_L2_DIAMOND_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL3RawCopperAmount")) {
            vc.addProperty("tradeL3RawCopperAmount", (Number)TRADE_L3_RAW_COPPER_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL4RawIronAmount")) {
            vc.addProperty("tradeL4RawIronAmount", (Number)TRADE_L4_RAW_IRON_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL4DiamondAmount")) {
            vc.addProperty("tradeL4DiamondAmount", (Number)TRADE_L4_DIAMOND_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL5GoldenAppleAmount")) {
            vc.addProperty("tradeL5GoldenAppleAmount", (Number)TRADE_L5_GOLDEN_APPLE_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL5NetherStarAmount")) {
            vc.addProperty("tradeL5NetherStarAmount", (Number)TRADE_L5_NETHER_STAR_AMOUNT);
            changed = true;
        }
        if (!vc.has("chestshopEnabled")) {
            vc.addProperty("chestshopEnabled", Boolean.valueOf(CHESTSHOP_ENABLED));
            changed = true;
        }
        if (!vc.has("tradeL1EuroAmount")) {
            vc.addProperty("tradeL1EuroAmount", (Number)TRADE_L1_EURO_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL2EuroAmount")) {
            vc.addProperty("tradeL2EuroAmount", (Number)TRADE_L2_EURO_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL3EuroAmount")) {
            vc.addProperty("tradeL3EuroAmount", (Number)TRADE_L3_EURO_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL4RawIronEuroAmount")) {
            vc.addProperty("tradeL4RawIronEuroAmount", (Number)TRADE_L4_RAW_IRON_EURO_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL4DiamondEuroAmount")) {
            vc.addProperty("tradeL4DiamondEuroAmount", (Number)TRADE_L4_DIAMOND_EURO_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL5GoldenAppleEuroAmount")) {
            vc.addProperty("tradeL5GoldenAppleEuroAmount", (Number)TRADE_L5_GOLDEN_APPLE_EURO_AMOUNT);
            changed = true;
        }
        if (!vc.has("tradeL5NetherStarEuroAmount")) {
            vc.addProperty("tradeL5NetherStarEuroAmount", (Number)TRADE_L5_NETHER_STAR_EURO_AMOUNT);
            changed = true;
        }
        if (changed) {
            try (FileWriter writer = new FileWriter(configFile);){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return changed;
    }

    private static void createDefaultConfig(File configFile) {
        try {
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
            JsonObject main = new JsonObject();
            main.addProperty("startMoney", (Number)START_MONEY);
            main.addProperty("moneyLossOnDeath", (Number)MONEY_LOSS_ON_DEATH);
            main.addProperty("paycheckEnabled", Boolean.valueOf(PAYCHECK_ENABLED));
            main.addProperty("paycheckAmount", (Number)PAYCHECK_AMOUNT);
            JsonObject vc = new JsonObject();
            vc.addProperty("tradesEnabled", Boolean.valueOf(VILLAGER_TRADES_ENABLED));
            vc.addProperty("tradeL1RawIronAmount", (Number)TRADE_L1_RAW_IRON_AMOUNT);
            vc.addProperty("tradeL2DiamondAmount", (Number)TRADE_L2_DIAMOND_AMOUNT);
            vc.addProperty("tradeL3RawCopperAmount", (Number)TRADE_L3_RAW_COPPER_AMOUNT);
            vc.addProperty("tradeL4RawIronAmount", (Number)TRADE_L4_RAW_IRON_AMOUNT);
            vc.addProperty("tradeL4DiamondAmount", (Number)TRADE_L4_DIAMOND_AMOUNT);
            vc.addProperty("tradeL5GoldenAppleAmount", (Number)TRADE_L5_GOLDEN_APPLE_AMOUNT);
            vc.addProperty("tradeL5NetherStarAmount", (Number)TRADE_L5_NETHER_STAR_AMOUNT);
            vc.addProperty("tradeL1EuroAmount", (Number)TRADE_L1_EURO_AMOUNT);
            vc.addProperty("tradeL2EuroAmount", (Number)TRADE_L2_EURO_AMOUNT);
            vc.addProperty("tradeL3EuroAmount", (Number)TRADE_L3_EURO_AMOUNT);
            vc.addProperty("tradeL4RawIronEuroAmount", (Number)TRADE_L4_RAW_IRON_EURO_AMOUNT);
            vc.addProperty("tradeL4DiamondEuroAmount", (Number)TRADE_L4_DIAMOND_EURO_AMOUNT);
            vc.addProperty("tradeL5GoldenAppleEuroAmount", (Number)TRADE_L5_GOLDEN_APPLE_EURO_AMOUNT);
            vc.addProperty("tradeL5NetherStarEuroAmount", (Number)TRADE_L5_NETHER_STAR_EURO_AMOUNT);
            main.add("villagerConfig", (JsonElement)vc);
            try (FileWriter writer = new FileWriter(configFile);){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)main, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

