/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.handlers.ContainerHandler;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ShopSignHandler {
    private static String stripFormatting(String text) {
        return text.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
    }

    public static void handleSignInteraction(UUID ownerUUID, Player customer, String itemName, double price, String type, BlockPos signPos) {
        if (!Config.CHESTSHOP_ENABLED) {
            return;
        }
        if (!(customer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverCustomer = (ServerPlayer)customer;
        Level level = customer.m_9236_();
        BlockState signState = level.m_8055_(signPos);
        BlockPos containerPos = ContainerHandler.getAttachedContainerPos(level, signPos, signState);
        BlockEntity blockEntity = level.m_7702_(containerPos);
        if (!(blockEntity instanceof Container)) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.no_container").m_130940_(ChatFormatting.RED));
            return;
        }
        Container container = (Container)blockEntity;
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            chest.m_6596_();
        }
        if (type.equalsIgnoreCase("buy")) {
            ShopSignHandler.handleBuyInteraction(ownerUUID, serverCustomer, itemName, price, container);
        } else if (type.equalsIgnoreCase("sell")) {
            ShopSignHandler.handleSellInteraction(ownerUUID, serverCustomer, itemName, price, container);
        }
        serverCustomer.f_36095_.m_38946_();
        serverCustomer.f_36096_.m_150429_();
    }

    private static void handleBuyInteraction(UUID ownerUUID, ServerPlayer customer, String itemName, double price, Container container) {
        double customerBalance = BalanceManager.getPlayerBalance(customer);
        if (customerBalance < price) {
            customer.m_213846_((Component)Component.m_237110_((String)"shop.error.not_enough_money", (Object[])new Object[]{String.format("%.2f", price)}).m_130940_(ChatFormatting.RED));
            return;
        }
        ItemStack itemToTransfer = null;
        int containerSlot = -1;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !ShopSignHandler.matchesItemName(stack, itemName)) continue;
            itemToTransfer = stack.m_41777_();
            containerSlot = i;
            break;
        }
        if (itemToTransfer == null) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.item_not_available").m_130940_(ChatFormatting.RED));
            return;
        }
        ItemStack singleItem = itemToTransfer.m_41777_();
        singleItem.m_41764_(1);
        if (!ShopSignHandler.hasInventorySpace(customer.m_150109_(), singleItem)) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.inventory_full").m_130940_(ChatFormatting.RED));
            return;
        }
        BalanceManager.updatePlayerBalance(customer, customerBalance - price);
        ShopSignHandler.addBalance(ownerUUID.toString(), price);
        container.m_7407_(containerSlot, 1);
        ShopSignHandler.addToInventory(customer, singleItem.m_41777_());
        ShopSignHandler.sendNotifications(customer, ownerUUID, itemName, price, "buy");
    }

    private static void handleSellInteraction(UUID ownerUUID, ServerPlayer customer, String itemName, double price, Container container) {
        String ownerUUIDString = ownerUUID.toString();
        double ownerBalance = BalanceManager.getBalance(ownerUUIDString);
        if (ownerBalance < price) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.owner_not_enough_money").m_130940_(ChatFormatting.RED));
            return;
        }
        ItemStack itemToSell = null;
        int inventorySlot = -1;
        Inventory inventory = customer.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !ShopSignHandler.matchesItemName(stack, itemName)) continue;
            itemToSell = stack.m_41777_();
            inventorySlot = i;
            break;
        }
        if (itemToSell == null) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.item_not_in_inventory").m_130940_(ChatFormatting.RED));
            return;
        }
        if (!ShopSignHandler.hasContainerSpace(container, itemToSell)) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.container_full").m_130940_(ChatFormatting.RED));
            return;
        }
        ShopSignHandler.addBalance(customer.m_20148_().toString(), price);
        BalanceManager.setBalance(ownerUUIDString, ownerBalance - price);
        inventory.m_7407_(inventorySlot, 1);
        ShopSignHandler.addToContainer(container, itemToSell.m_41777_());
        ShopSignHandler.sendNotifications(customer, ownerUUID, itemName, price, "sell");
    }

    private static boolean matchesItemName(ItemStack stack, String searchName) {
        String stackName = ShopSignHandler.stripFormatting(stack.m_41786_().getString());
        return stackName.equalsIgnoreCase(ShopSignHandler.stripFormatting(searchName));
    }

    private static void addToInventory(ServerPlayer player, ItemStack itemStack) {
        int i;
        Inventory inventory = player.m_150109_();
        for (i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.m_41613_() >= stack.m_41741_()) continue;
            stack.m_41769_(1);
            inventory.m_6836_(i, stack);
            return;
        }
        for (i = 0; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            inventory.m_6836_(i, itemStack);
            return;
        }
    }

    private static void sendNotifications(ServerPlayer customer, UUID ownerUUID, String itemName, double price, String type) {
        if (type.equals("buy")) {
            customer.m_213846_((Component)Component.m_237110_((String)"shop.buy.success", (Object[])new Object[]{itemName, String.format("%.2f", price)}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
            ServerPlayer owner = customer.m_20194_().m_6846_().m_11259_(ownerUUID);
            if (owner != null) {
                owner.m_213846_((Component)Component.m_237110_((String)"shop.buy.owner_notification", (Object[])new Object[]{customer.m_5446_().getString(), itemName, String.format("%.2f", price)}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
            }
        } else {
            customer.m_213846_((Component)Component.m_237110_((String)"shop.sell.success", (Object[])new Object[]{itemName, String.format("%.2f", price)}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
            ServerPlayer owner = customer.m_20194_().m_6846_().m_11259_(ownerUUID);
            if (owner != null) {
                owner.m_213846_((Component)Component.m_237110_((String)"shop.sell.owner_notification", (Object[])new Object[]{customer.m_5446_().getString(), itemName, String.format("%.2f", price)}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
            }
        }
    }

    private static void addBalance(String playerUUID, double amount) {
        double current = BalanceManager.getBalance(playerUUID);
        BalanceManager.setBalance(playerUUID, current + amount);
    }

    private static boolean hasInventorySpace(Inventory inventory, ItemStack itemStack) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.m_41613_() >= stack.m_41741_()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasContainerSpace(Container container, ItemStack itemStack) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.m_41613_() >= stack.m_41741_()) continue;
            return true;
        }
        return false;
    }

    private static void addToContainer(Container container, ItemStack itemStack) {
        int i;
        for (i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.m_41613_() >= stack.m_41741_()) continue;
            stack.m_41769_(1);
            container.m_6836_(i, stack);
            return;
        }
        for (i = 0; i < container.m_6643_(); ++i) {
            if (!container.m_8020_(i).m_41619_()) continue;
            container.m_6836_(i, itemStack);
            return;
        }
    }
}

