/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.integration;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModItems;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ScoreboardMoneySync {
    public static final String OBJ_BALANCE_TOTAL = "saro_balance_total";
    public static final String OBJ_COIN_VALUE_TOTAL = "saro_coin_value_total";
    private static final Map<String, CoinDef> COIN_DEFS = new LinkedHashMap<String, CoinDef>();

    private static void ensureObjectives(Scoreboard scoreboard) {
        ScoreboardMoneySync.ensureObjective(scoreboard, OBJ_BALANCE_TOTAL, "SMM: Balance (cents)");
        ScoreboardMoneySync.ensureObjective(scoreboard, OBJ_COIN_VALUE_TOTAL, "SMM: Coins Value (cents)");
        for (CoinDef def : COIN_DEFS.values()) {
            ScoreboardMoneySync.ensureObjective(scoreboard, def.objectiveName, "SMM: " + def.objectiveName);
        }
    }

    private static Objective ensureObjective(Scoreboard scoreboard, String name, String displayName) {
        Objective obj = scoreboard.m_83477_(name);
        if (obj == null) {
            obj = scoreboard.m_83436_(name, ObjectiveCriteria.f_83588_, (Component)Component.m_237113_((String)displayName), ObjectiveCriteria.RenderType.INTEGER);
        }
        return obj;
    }

    private static void setScore(Scoreboard scoreboard, String playerName, String objectiveName, int value) {
        Objective obj = scoreboard.m_83477_(objectiveName);
        if (obj == null) {
            obj = ScoreboardMoneySync.ensureObjective(scoreboard, objectiveName, objectiveName);
        }
        Score score = scoreboard.m_83471_(playerName, obj);
        score.m_83402_(value);
    }

    private static void updateCoinsForPlayer(ServerPlayer player) {
        Scoreboard sb = player.m_36329_();
        ScoreboardMoneySync.ensureObjectives(sb);
        Inventory inv = player.m_150109_();
        String name = player.m_6302_();
        int totalCoinValueCents = 0;
        for (Map.Entry<String, CoinDef> e : COIN_DEFS.entrySet()) {
            CoinDef def = e.getValue();
            Item match = (Item)def.item().get();
            int count = 0;
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (stack.m_41619_() || stack.m_41720_() != match) continue;
                count += stack.m_41613_();
            }
            ScoreboardMoneySync.setScore(sb, name, def.objectiveName(), count);
            totalCoinValueCents += count * def.centsPer();
        }
        ScoreboardMoneySync.setScore(sb, name, OBJ_COIN_VALUE_TOTAL, totalCoinValueCents);
    }

    private static void updateBalanceForPlayer(ServerPlayer player) {
        Scoreboard sb = player.m_36329_();
        ScoreboardMoneySync.ensureObjectives(sb);
        String uuid = player.m_20148_().toString();
        int cents = (int)Math.round(BalanceManager.getBalance(uuid) * 100.0);
        ScoreboardMoneySync.setScore(sb, player.m_6302_(), OBJ_BALANCE_TOTAL, cents);
    }

    public static void updateForPlayer(ServerPlayer player) {
        ScoreboardMoneySync.updateCoinsForPlayer(player);
        ScoreboardMoneySync.updateBalanceForPlayer(player);
    }

    public static void updateBalanceForOnlinePlayer(String playerUUID) {
        ServerPlayer player = ScoreboardMoneySync.playerFromUUID(playerUUID);
        if (player != null) {
            ScoreboardMoneySync.updateBalanceForPlayer(player);
        }
    }

    private static ServerPlayer playerFromUUID(String uuidStr) {
        try {
            UUID uuid = UUID.fromString(uuidStr);
            return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    static {
        COIN_DEFS.put("euro_1", new CoinDef("saro_coin_euro_1_count", 100, SarosMoneyModModItems.EURO_1));
        COIN_DEFS.put("euro_2", new CoinDef("saro_coin_euro_2_count", 200, SarosMoneyModModItems.EURO_2));
        COIN_DEFS.put("euro_5", new CoinDef("saro_coin_euro_5_count", 500, SarosMoneyModModItems.EURO_5));
        COIN_DEFS.put("euro_10", new CoinDef("saro_coin_euro_10_count", 1000, SarosMoneyModModItems.EURO_10));
        COIN_DEFS.put("euro_20", new CoinDef("saro_coin_euro_20_count", 2000, SarosMoneyModModItems.EURO_20));
        COIN_DEFS.put("euro_50", new CoinDef("saro_coin_euro_50_count", 5000, SarosMoneyModModItems.EURO_50));
        COIN_DEFS.put("euro_100", new CoinDef("saro_coin_euro_100_count", 10000, SarosMoneyModModItems.EURO_100));
        COIN_DEFS.put("euro_200", new CoinDef("saro_coin_euro_200_count", 20000, SarosMoneyModModItems.EURO_200));
        COIN_DEFS.put("euro_500", new CoinDef("saro_coin_euro_500_count", 50000, SarosMoneyModModItems.EURO_500));
        COIN_DEFS.put("cent_1", new CoinDef("saro_coin_cent_1_count", 1, SarosMoneyModModItems.CENT_1));
        COIN_DEFS.put("cent_2", new CoinDef("saro_coin_cent_2_count", 2, SarosMoneyModModItems.CENT_2));
        COIN_DEFS.put("cent_5", new CoinDef("saro_coin_cent_5_count", 5, SarosMoneyModModItems.CENT_5));
        COIN_DEFS.put("cent_10", new CoinDef("saro_coin_cent_10_count", 10, SarosMoneyModModItems.CENT_10));
        COIN_DEFS.put("cent_20", new CoinDef("saro_coin_cent_20_count", 20, SarosMoneyModModItems.CENT_20));
        COIN_DEFS.put("cent_50", new CoinDef("saro_coin_cent_50_count", 50, SarosMoneyModModItems.CENT_50));
    }

    private record CoinDef(String objectiveName, int centsPer, RegistryObject<Item> item) {
    }

    @Mod.EventBusSubscriber(modid="saros__money_mod")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            Player player = event.player;
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            if (sp.f_19797_ % 20 != 0) {
                return;
            }
            try {
                ScoreboardMoneySync.updateForPlayer(sp);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @SubscribeEvent
        public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            try {
                ScoreboardMoneySync.ensureObjectives(sp.m_36329_());
                ScoreboardMoneySync.updateForPlayer(sp);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

