/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.SarosMoneyModMod;
import de.sarocesch.sarosmoneymod.handlers.ServerHandler;
import de.sarocesch.sarosmoneymod.handlers.ShopSignHandler;
import de.sarocesch.sarosmoneymod.network.NetworkHandler;
import de.sarocesch.sarosmoneymod.network.SignUpdatePacket;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="saros__money_mod")
public class SignShopListener {
    @OnlyIn(value=Dist.CLIENT)
    private static Field signField;

    @OnlyIn(value=Dist.CLIENT)
    private static void initSignField() {
        try {
            signField = ObfuscationReflectionHelper.findField(AbstractSignEditScreen.class, (String)"sign");
            signField.setAccessible(true);
        }
        catch (Exception e) {
            SarosMoneyModMod.LOGGER.error("Failed to find sign field:", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onSignPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!Config.CHESTSHOP_ENABLED) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            BlockPos signPos;
            Player player = (Player)entity;
            Level level = (Level)event.getLevel();
            BlockEntity blockEntity = level.m_7702_(signPos = event.getPos());
            if (blockEntity instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                CompoundTag nbt = sign.getPersistentData();
                nbt.m_128362_("OwnerUUID", player.m_20148_());
                BlockState signState = level.m_8055_(signPos);
                Direction facing = Direction.NORTH;
                if (signState.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    facing = (Direction)signState.m_61143_((Property)BlockStateProperties.f_61374_);
                } else if (signState.m_61138_((Property)BlockStateProperties.f_61390_)) {
                    int rotation = (Integer)signState.m_61143_((Property)BlockStateProperties.f_61390_);
                    facing = Direction.m_122407_((int)(rotation / 4));
                }
                BlockPos containerPos = signPos.m_121945_(facing.m_122424_());
                nbt.m_128385_("ContainerPos", new int[]{containerPos.m_123341_(), containerPos.m_123342_(), containerPos.m_123343_()});
                sign.m_6596_();
                if (!level.m_5776_() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ServerHandler.handleSignUpdate(serverPlayer, signPos);
                    if (level.m_7654_() != null) {
                        level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + 1, () -> ServerHandler.handleSignUpdate(serverPlayer, signPos)));
                        level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + 5, () -> ServerHandler.handleSignUpdate(serverPlayer, signPos)));
                        level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + 10, () -> ServerHandler.handleSignUpdate(serverPlayer, signPos)));
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        UUID ownerUUID;
        BlockEntity nbt;
        SignBlockEntity sign;
        BlockPos pos;
        Player player = event.getPlayer();
        Level level = player.m_9236_();
        if (level.m_7702_(pos = event.getPos()) instanceof Container && (sign = SignShopListener.findLinkedSign(level, pos)) != null && (nbt = sign.getPersistentData()).m_128441_("OwnerUUID")) {
            ownerUUID = nbt.m_128342_("OwnerUUID");
            if (!player.m_20148_().equals(ownerUUID) && !player.m_7500_()) {
                event.setCanceled(true);
                player.m_5661_((Component)Component.m_237115_((String)"shop.protection.container_owner_only").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))), true);
            }
        }
        if ((nbt = level.m_7702_(pos)) instanceof SignBlockEntity && (nbt = (sign = (SignBlockEntity)nbt).getPersistentData()).m_128441_("OwnerUUID")) {
            ownerUUID = nbt.m_128342_("OwnerUUID");
            if (!player.m_20148_().equals(ownerUUID) && !player.m_7500_()) {
                event.setCanceled(true);
                player.m_5661_((Component)Component.m_237115_((String)"shop.protection.sign_owner_only").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        CompoundTag nbt;
        SignBlockEntity sign;
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (!level.m_5776_() && level.m_7702_(pos) instanceof Container && (sign = SignShopListener.findLinkedSign(level, pos)) != null && (nbt = sign.getPersistentData()).m_128441_("OwnerUUID")) {
            UUID ownerUUID = nbt.m_128342_("OwnerUUID");
            if (!player.m_20148_().equals(ownerUUID)) {
                event.setCanceled(true);
                player.m_5661_((Component)Component.m_237115_((String)"shop.protection.container_use_owner_only").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))), true);
                return;
            }
        }
    }

    private static SignBlockEntity findLinkedSign(Level level, BlockPos containerPos) {
        for (BlockPos pos : BlockPos.m_121925_((BlockPos)containerPos, (int)5, (int)5, (int)5)) {
            int[] coords;
            BlockPos linkedPos;
            SignBlockEntity sign;
            CompoundTag nbt;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof SignBlockEntity) || !(nbt = (sign = (SignBlockEntity)blockEntity).getPersistentData()).m_128441_("ContainerPos") || !(linkedPos = new BlockPos((coords = nbt.m_128465_("ContainerPos"))[0], coords[1], coords[2])).equals((Object)containerPos)) continue;
            return sign;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onSignClose(ScreenEvent.Closing event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractSignEditScreen) {
            AbstractSignEditScreen screen2 = (AbstractSignEditScreen)screen;
            Minecraft.m_91087_().m_6937_(() -> {
                try {
                    Field signField = ObfuscationReflectionHelper.findField(AbstractSignEditScreen.class, (String)"sign");
                    SignBlockEntity sign = (SignBlockEntity)signField.get(screen2);
                    sign.m_6596_();
                    Level level = sign.m_58904_();
                    if (level != null) {
                        level.m_7260_(sign.m_58899_(), level.m_8055_(sign.m_58899_()), level.m_8055_(sign.m_58899_()), 3);
                    }
                    NetworkHandler.INSTANCE.sendToServer((Object)new SignUpdatePacket(sign.m_58899_()));
                }
                catch (Exception e) {
                    SarosMoneyModMod.LOGGER.error("Sign update failed", (Throwable)e);
                }
            });
        }
    }

    private static String stripFormatting(Component component) {
        return component.getString().replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onContainerInteract(PlayerInteractEvent.RightClickBlock event) {
        CompoundTag nbt;
        SignBlockEntity sign;
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (level.m_5776_()) {
            return;
        }
        if (level.m_7702_(pos) instanceof Container && (sign = SignShopListener.findLinkedSign(level, pos)) != null && (nbt = sign.getPersistentData()).m_128441_("OwnerUUID")) {
            UUID ownerUUID = nbt.m_128342_("OwnerUUID");
            if (!player.m_20148_().equals(ownerUUID) && !player.m_7500_()) {
                boolean isShopInteraction;
                boolean bl = isShopInteraction = player.m_21205_().m_41619_() && SignShopListener.isShopSign(sign.m_277157_(true).m_276945_(true)[0].getString());
                if (!isShopInteraction) {
                    event.setCanceled(true);
                    player.m_5661_((Component)Component.m_237115_((String)"shop.protection.container_owner_only").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))), true);
                }
            }
        }
    }

    private static boolean isShopSign(String firstLine) {
        String line = SignShopListener.stripFormatting((Component)Component.m_237113_((String)firstLine)).trim().toLowerCase();
        return line.contains("[shop]") || line.contains("[buy]") || line.contains("[sell]");
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (!Config.CHESTSHOP_ENABLED) {
            return;
        }
        if (event.getLevel().m_5776_()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            Component[] lines = sign.m_277157_(true).m_276945_(true);
            String[] signContent = new String[4];
            for (int i = 0; i < 4; ++i) {
                signContent[i] = SignShopListener.stripFormatting(lines[i]).trim();
            }
            String firstLine = signContent[0].toLowerCase();
            if (!firstLine.matches("\\[?(buy|sell|shop)\\]?")) {
                return;
            }
            event.setCanceled(true);
            CompoundTag nbt = sign.getPersistentData();
            UUID ownerUUID = nbt.m_128441_("OwnerUUID") ? nbt.m_128342_("OwnerUUID") : null;
            try {
                String type = "";
                String itemId = "";
                String priceStr = "";
                if (firstLine.equals("[shop]")) {
                    type = signContent[1].toLowerCase();
                    itemId = signContent[2];
                    priceStr = signContent[3];
                } else {
                    type = firstLine.replaceAll("[\\[\\]]", "").toLowerCase();
                    if (signContent[1].isEmpty()) {
                        itemId = signContent[2];
                        priceStr = signContent[3];
                    } else {
                        itemId = signContent[1];
                        priceStr = signContent[2];
                    }
                }
                if (itemId.isEmpty() || priceStr.isEmpty()) {
                    throw new IllegalArgumentException("Missing item or price");
                }
                double price = Double.parseDouble(priceStr.replaceAll("[^\\d.,]", "").replace(",", "."));
                Item item = null;
                try {
                    String sanitizedItemId = itemId.toLowerCase().replace(" ", "_");
                    ResourceLocation itemKey = new ResourceLocation(sanitizedItemId);
                    item = (Item)ForgeRegistries.ITEMS.getValue(itemKey);
                    if (item == null) {
                        itemKey = new ResourceLocation("minecraft", sanitizedItemId);
                        item = (Item)ForgeRegistries.ITEMS.getValue(itemKey);
                    }
                    if (item == null) {
                        throw new IllegalArgumentException("Invalid item: " + itemId);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid item: " + itemId);
                }
                ShopSignHandler.handleSignInteraction(ownerUUID, player, item.m_41466_().getString(), price, type, pos);
            }
            catch (Exception e) {
                SarosMoneyModMod.LOGGER.error("[Shop Error] Interaction failed: {}", (Object)e.getMessage());
                player.m_213846_((Component)Component.m_237113_((String)("Shop Error: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            }
        }
    }

    @SubscribeEvent
    public static void onSignChanged(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity = event.getLevel();
            if (entity instanceof Level) {
                Level level = (Level)entity;
                BlockPos pos = event.getPos();
                level.m_7654_().execute(() -> {
                    BlockEntity patt22141$temp = level.m_7702_(pos);
                    if (patt22141$temp instanceof SignBlockEntity) {
                        SignBlockEntity sign = (SignBlockEntity)patt22141$temp;
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            ServerHandler.handleSignUpdate(serverPlayer, pos);
                        }
                    }
                });
            }
        }
    }

    private static void processShopInteraction(SignBlockEntity sign, Player player, BlockPos pos) {
        CompoundTag nbt = sign.getPersistentData();
        UUID ownerUUID = nbt.m_128441_("OwnerUUID") ? nbt.m_128342_("OwnerUUID") : null;
        try {
            SignText signText = sign.m_277157_(true);
            Component[] messages = signText.m_276945_(true);
            String[] lines = new String[4];
            for (int i = 0; i < 4; ++i) {
                lines[i] = SignShopListener.stripFormatting(messages[i]).trim();
            }
            String type = null;
            String itemId = null;
            String priceStr = null;
            if (lines[0].equalsIgnoreCase("[shop]")) {
                type = lines[1].toLowerCase();
                itemId = lines[2];
                priceStr = lines[3];
            } else if (lines[0].equalsIgnoreCase("[buy]") || lines[0].equalsIgnoreCase("[sell]")) {
                type = lines[0].substring(1, lines[0].length() - 1).toLowerCase();
                itemId = lines[1];
                priceStr = lines[2];
            } else {
                return;
            }
            double price = Double.parseDouble(priceStr.replaceAll("[^0-9.,]", "").replace(',', '.'));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId.toLowerCase()));
            if (item != null) {
                ShopSignHandler.handleSignInteraction(ownerUUID, player, item.m_41466_().getString(), price, type, pos);
            }
        }
        catch (Exception e) {
            player.m_5661_((Component)Component.m_237115_((String)"shop.error.invalid_shop_config").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
        }
    }

    private static boolean hasShopContentInOtherLines(Component[] lines) {
        for (int i = 1; i < lines.length; ++i) {
            String line = SignShopListener.stripFormatting(lines[i]).trim().toLowerCase();
            if (!line.contains("shop") && !line.contains("buy") && !line.contains("sell")) continue;
            return true;
        }
        return false;
    }
}

