/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.network;

import de.sarocesch.sarosmoneymod.SarosMoneyModMod;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.procedures.DepositProcedure;
import de.sarocesch.sarosmoneymod.procedures.WithdrawProcedure;
import de.sarocesch.sarosmoneymod.world.inventory.ATMGUIMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ATMGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private final String withdrawValue;

    public ATMGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.withdrawValue = buffer.m_130136_(Short.MAX_VALUE);
    }

    public ATMGUIButtonMessage(int buttonID, int x, int y, int z, String withdrawValue) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.withdrawValue = withdrawValue;
    }

    public static void buffer(ATMGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.m_130072_(message.withdrawValue, Short.MAX_VALUE);
    }

    public static void handler(ATMGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            if (entity != null) {
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                String withdrawValue = message.withdrawValue;
                ATMGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, withdrawValue);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, String withdrawValue) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ATMGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (buttonID == 0) {
                WithdrawProcedure.execute((Entity)serverPlayer, guistate, withdrawValue, serverPlayer);
            }
            if (buttonID == 1) {
                DepositProcedure.execute((Entity)serverPlayer, guistate, withdrawValue, serverPlayer);
            }
            double playerBalance = BalanceManager.getPlayerBalance(serverPlayer);
            int wholePart = (int)playerBalance;
            int decimalPart = (int)((playerBalance - (double)wholePart) * 100.0);
            AbstractContainerMenu abstractContainerMenu = entity.f_36096_;
            if (abstractContainerMenu instanceof ATMGUIMenu) {
                ATMGUIMenu menu = (ATMGUIMenu)abstractContainerMenu;
                menu.balanceWhole.m_6422_(wholePart);
                menu.balanceDecimal.m_6422_(decimalPart);
                menu.m_38946_();
            }
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SarosMoneyModMod.addNetworkMessage(ATMGUIButtonMessage.class, ATMGUIButtonMessage::buffer, ATMGUIButtonMessage::new, ATMGUIButtonMessage::handler);
    }
}

