/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.procedures;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModItems;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WithdrawProcedure {
    public static void execute(Entity entity, HashMap guistate, String withdrawValue, ServerPlayer player) {
        Player _player;
        if (entity == null || guistate == null) {
            return;
        }
        if (entity instanceof Player && !(_player = (Player)entity).m_9236_().m_5776_()) {
            try {
                double amount = (double)Math.round(Double.parseDouble(withdrawValue) * 100.0) / 100.0;
                if (amount > 0.0) {
                    String playerUUID = _player.m_20148_().toString();
                    double currentBalance = BalanceManager.getBalance(playerUUID);
                    if (amount <= currentBalance + 1.0E-6) {
                        Map<Integer, ItemStack> items = WithdrawProcedure.convertAmountToItems(amount);
                        if (WithdrawProcedure.canFitItems(_player, items)) {
                            WithdrawProcedure.addItemsToPlayerInventory(_player, items);
                            double newBalance = currentBalance - amount;
                            BalanceManager.setBalance(playerUUID, newBalance);
                            _player.m_5661_((Component)Component.m_237115_((String)"lang.withdraw.previous_balance").m_130946_(String.format("%.2f", currentBalance) + "\u20ac"), false);
                            _player.m_5661_((Component)Component.m_237115_((String)"lang.withdraw.withdrawn_amount").m_130946_(String.format("%.2f", amount) + "\u20ac"), false);
                            _player.m_5661_((Component)Component.m_237115_((String)"lang.withdraw.new_balance").m_130946_(String.format("%.2f", newBalance) + "\u20ac"), false);
                            ((EditBox)guistate.get("text:withdraw")).m_94144_("");
                        } else {
                            _player.m_5661_((Component)Component.m_237115_((String)"lang.withdraw.not_enough_inventory"), false);
                        }
                    } else {
                        _player.m_5661_((Component)Component.m_237115_((String)"lang.withdraw.not_enough_balance"), false);
                    }
                } else {
                    _player.m_5661_((Component)Component.m_237115_((String)"lang.withdraw.enter_positive_number"), false);
                }
            }
            catch (NumberFormatException e) {
                _player.m_5661_((Component)Component.m_237115_((String)"lang.withdraw.enter_valid_number"), false);
            }
        }
    }

    private static Map<Integer, ItemStack> convertAmountToItems(double amount) {
        int cents = (int)Math.round(amount * 100.0);
        LinkedHashMap<Integer, ItemStack> items = new LinkedHashMap<Integer, ItemStack>();
        int[] denom = new int[]{50000, 20000, 10000, 5000, 2000, 1000, 500, 200, 100, 50, 20, 10, 5, 2, 1};
        ItemStack[] stacks = new ItemStack[]{new ItemStack((ItemLike)SarosMoneyModModItems.EURO_500.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_200.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_100.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_50.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_20.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_10.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_5.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_2.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_1.get()), new ItemStack((ItemLike)SarosMoneyModModItems.CENT_50.get()), new ItemStack((ItemLike)SarosMoneyModModItems.CENT_20.get()), new ItemStack((ItemLike)SarosMoneyModModItems.CENT_10.get()), new ItemStack((ItemLike)SarosMoneyModModItems.CENT_5.get()), new ItemStack((ItemLike)SarosMoneyModModItems.CENT_2.get()), new ItemStack((ItemLike)SarosMoneyModModItems.CENT_1.get())};
        int remaining = cents;
        for (int i = 0; i < denom.length; ++i) {
            int count = remaining / denom[i];
            if (count <= 0) continue;
            ItemStack s = stacks[i].m_41777_();
            s.m_41764_(count);
            items.put(denom[i], s);
            remaining %= denom[i];
        }
        return items;
    }

    private static boolean canFitItems(Player player, Map<Integer, ItemStack> items) {
        int freeSlots = 0;
        int slotsNeeded = 0;
        for (ItemStack invStack : player.m_150109_().f_35974_) {
            if (!invStack.m_41619_()) continue;
            ++freeSlots;
        }
        for (ItemStack stack : items.values()) {
            ItemStack invStack;
            int need = stack.m_41613_();
            Iterator iterator = player.m_150109_().f_35974_.iterator();
            while (iterator.hasNext() && (!ItemStack.m_150942_((ItemStack)(invStack = (ItemStack)iterator.next()), (ItemStack)stack) || (need -= invStack.m_41741_() - invStack.m_41613_()) > 0)) {
            }
            if (need <= 0) continue;
            slotsNeeded += (need + stack.m_41741_() - 1) / stack.m_41741_();
        }
        return freeSlots >= slotsNeeded;
    }

    private static void addItemsToPlayerInventory(Player player, Map<Integer, ItemStack> items) {
        for (ItemStack stack : items.values()) {
            while (!stack.m_41619_()) {
                boolean placed = false;
                for (ItemStack invStack : player.m_150109_().f_35974_) {
                    if (!ItemStack.m_150942_((ItemStack)invStack, (ItemStack)stack) || invStack.m_41613_() >= invStack.m_41741_()) continue;
                    int move = Math.min(stack.m_41613_(), invStack.m_41741_() - invStack.m_41613_());
                    invStack.m_41769_(move);
                    stack.m_41774_(move);
                    placed = true;
                    if (!stack.m_41619_()) continue;
                    break;
                }
                if (placed || stack.m_41619_()) continue;
                player.m_36356_(stack.m_41620_(stack.m_41741_()));
            }
        }
    }
}

