/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import de.sarocesch.sarosmoneymod.handlers.ContainerHandler;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handleSignUpdate(@Nullable ServerPlayer player, BlockPos signPos) {
        BlockEntity blockEntity;
        Level level;
        Level level2 = level = player != null ? player.m_9236_() : null;
        if (level == null) {
            LOGGER.warn("[Shop] Cannot process sign update: invalid level");
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_46819_(signPos.m_123341_() >> 4, signPos.m_123343_() >> 4, ChunkStatus.f_62326_);
        }
        if ((blockEntity = level.m_7702_(signPos)) instanceof SignBlockEntity) {
            MutableComponent itemName;
            boolean updated;
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            sign.m_6596_();
            BlockState signState = level.m_8055_(signPos);
            BlockPos containerPos = ContainerHandler.getAttachedContainerPos(level, signPos, signState);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_46819_(containerPos.m_123341_() >> 4, containerPos.m_123343_() >> 4, ChunkStatus.f_62326_);
                BlockEntity containerEntity = level.m_7702_(containerPos);
                if (containerEntity != null) {
                    containerEntity.m_6596_();
                }
            }
            if (updated = ServerHandler.updateSignText(sign, containerPos, itemName = ServerHandler.getItemName(level, containerPos))) {
                ServerHandler.syncSignWithClient(level, signPos, sign);
                if (level.m_7654_() != null) {
                    level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + 1, () -> {
                        ServerHandler.syncSignWithClient(level, signPos, sign);
                        level.m_7260_(signPos, signState, signState, 3);
                    }));
                }
            }
        }
    }

    private static boolean updateSignText(SignBlockEntity sign, BlockPos containerPos, MutableComponent itemName) {
        SignText frontText = sign.m_277157_(true);
        Component[] lines = frontText.m_276945_(true);
        String firstLine = ServerHandler.stripFormatting(lines[0]).trim().toLowerCase();
        boolean isShop = firstLine.equals("[shop]");
        boolean isBuy = firstLine.equals("[buy]");
        boolean isSell = firstLine.equals("[sell]");
        if (!(isShop || isBuy || isSell)) {
            return false;
        }
        ChatFormatting color = isBuy ? ChatFormatting.BLUE : (isSell ? ChatFormatting.GOLD : ChatFormatting.DARK_GREEN);
        Component[] newLines = new Component[4];
        newLines[0] = Component.m_237113_((String)(isShop ? "[SHOP]" : (isBuy ? "[BUY]" : "[SELL]"))).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(color));
        newLines[1] = lines[1].m_6881_();
        newLines[2] = itemName;
        try {
            String priceText = ServerHandler.stripFormatting(lines[3]).replaceAll("[^\\d.,]", "").replace(',', '.');
            if (priceText.isEmpty()) {
                throw new NumberFormatException("Empty price");
            }
            double price = Double.parseDouble(priceText);
            newLines[3] = Component.m_237113_((String)("$" + String.format("%.2f", price))).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(color));
        }
        catch (Exception e) {
            LOGGER.error("Invalid price format: {}", (Object)e.getMessage());
            newLines[3] = Component.m_237113_((String)"Invalid Price").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (itemName.getString().isEmpty()) {
            LOGGER.error("[Shop Error] Missing item in container at {}", (Object)containerPos);
            newLines[2] = Component.m_237113_((String)"!NO ITEM!").m_130940_(ChatFormatting.RED);
        }
        SignText newSignText = new SignText(newLines, newLines, frontText.m_276773_(), frontText.m_276843_());
        sign.m_276956_(newSignText, true);
        sign.m_276956_(newSignText, false);
        sign.m_6596_();
        if (sign.m_58904_() != null) {
            sign.m_58904_().m_46745_(sign.m_58899_()).m_8092_(true);
        }
        return true;
    }

    private static void syncSignWithClient(Level level, BlockPos pos, SignBlockEntity sign) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)sign);
        serverLevel.m_7726_().f_8325_.m_183262_(serverLevel.m_46745_(pos).m_7697_(), false).forEach(player -> player.f_8906_.m_9829_((Packet)packet));
        BlockState state = level.m_8055_(pos);
        level.m_7260_(pos, state, state, 3);
    }

    private static MutableComponent getItemName(Level level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof Container) {
            Container container = (Container)be;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_()) continue;
                String rawName = ServerHandler.stripFormatting(stack.m_41786_());
                return Component.m_237113_((String)rawName).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
            }
        }
        return Component.m_237113_((String)"").m_130948_(Style.f_131099_);
    }

    private static String stripFormatting(Component component) {
        return component.getString().replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    private static Item getItemFromContainer(BlockPos containerPos, Level level) {
        BlockEntity be = level.m_7702_(containerPos);
        if (be instanceof Container) {
            Container container = (Container)be;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_()) continue;
                return stack.m_41720_();
            }
        }
        return Items.f_41852_;
    }
}

