/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod;

import de.sarocesch.sarosmoneymod.data.BalanceMigrator;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModBlockEntities;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModBlocks;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModItems;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModMenus;
import de.sarocesch.sarosmoneymod.listener.SignShopListener;
import de.sarocesch.sarosmoneymod.network.NetworkHandler;
import de.sarocesch.sarosmoneymod.villager.ModVillagers;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="saros__money_mod")
public class SarosMoneyModMod {
    public static final Logger LOGGER = LogManager.getLogger(SarosMoneyModMod.class);
    public static final String MODID = "saros__money_mod";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("saros__money_mod", "saros__money_mod"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public SarosMoneyModMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)new SignShopListener());
        NetworkHandler.register();
        SarosMoneyModModBlocks.REGISTRY.register(bus);
        SarosMoneyModModItems.REGISTRY.register(bus);
        SarosMoneyModModBlockEntities.REGISTRY.register(bus);
        ModVillagers.register(bus);
        SarosMoneyModModMenus.REGISTRY.register(bus);
    }

    @SubscribeEvent
    public static void serverLoad(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        BalanceMigrator.migrateOldData(server);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

