/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EcoCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"eco").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(EcoCommand.getOnlinePlayerNames((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(context -> EcoCommand.addBalance((CommandContext<CommandSourceStack>)context)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(EcoCommand.getOnlinePlayerNames((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> EcoCommand.setBalance((CommandContext<CommandSourceStack>)context)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"take").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(EcoCommand.getOnlinePlayerNames((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(context -> EcoCommand.takeBalance((CommandContext<CommandSourceStack>)context)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(EcoCommand.getOnlinePlayerNames((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(context -> EcoCommand.getBalance((CommandContext<CommandSourceStack>)context)))));
    }

    private static int addBalance(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        double amount = DoubleArgumentType.getDouble(context, (String)"amount");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(playerName);
        if (player != null) {
            UUID playerUUID = player.m_20148_();
            double currentBalance = BalanceManager.getPlayerBalance(player);
            double newBalance = currentBalance + amount;
            BalanceManager.updatePlayerBalance(player, newBalance);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("\u00a7a" + Component.m_237110_((String)"command.eco.add.success", (Object[])new Object[]{String.format("%.2f", amount), playerName, String.format("%.2f", newBalance)}).getString())), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c" + Component.m_237115_((String)"command.eco.player_not_found").getString())));
        return 0;
    }

    private static int setBalance(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        double amount = DoubleArgumentType.getDouble(context, (String)"amount");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(playerName);
        if (player != null) {
            BalanceManager.updatePlayerBalance(player, amount);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("\u00a7a" + Component.m_237110_((String)"command.eco.set.success", (Object[])new Object[]{String.format("%.2f", amount), playerName}).getString())), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c" + Component.m_237115_((String)"command.eco.player_not_found").getString())));
        return 0;
    }

    private static int takeBalance(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        double amount = DoubleArgumentType.getDouble(context, (String)"amount");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(playerName);
        if (player != null) {
            double currentBalance = BalanceManager.getPlayerBalance(player);
            double newBalance = currentBalance - amount;
            BalanceManager.updatePlayerBalance(player, newBalance);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("\u00a7a" + Component.m_237110_((String)"command.eco.take.success", (Object[])new Object[]{String.format("%.2f", amount), playerName, String.format("%.2f", newBalance)}).getString())), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c" + Component.m_237115_((String)"command.eco.player_not_found").getString())));
        return 0;
    }

    private static int getBalance(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(playerName);
        if (player != null) {
            double currentBalance = BalanceManager.getPlayerBalance(player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("\u00a7a" + Component.m_237110_((String)"command.eco.get.success", (Object[])new Object[]{playerName, String.format("%.2f", currentBalance)}).getString())), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c" + Component.m_237115_((String)"command.eco.player_not_found").getString())));
        return 0;
    }

    private static List<String> getOnlinePlayerNames(CommandContext<CommandSourceStack> context) {
        return ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_().stream().map(Player::m_36316_).map(profile -> profile.getName()).collect(Collectors.toList());
    }
}

