/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DeathMoneyListener {
    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        int deathMoneyLoss = Config.MONEY_LOSS_ON_DEATH;
        if (deathMoneyLoss == 0) {
            return;
        }
        String playerUUID = player.m_20148_().toString();
        double balance = BalanceManager.getBalance(playerUUID);
        double newBalance = Math.max(balance - (double)deathMoneyLoss, 0.0);
        BalanceManager.setBalance(playerUUID, newBalance);
        player.m_213846_((Component)Component.m_237110_((String)"message.death_money_loss", (Object[])new Object[]{deathMoneyLoss, newBalance}));
    }
}

