/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MoneyCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"money").executes(MoneyCommand::showBalance));
    }

    private static int showBalance(CommandContext<CommandSourceStack> context) {
        ServerPlayer player;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            player = source.m_81375_();
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237115_((String)"command.money.not_a_player"));
            return 0;
        }
        String playerUUID = player.m_20148_().toString();
        Map<String, Double> balances = BalanceManager.loadBalances(source.m_81377_());
        double balance = balances.getOrDefault(playerUUID, 0.0);
        player.m_213846_((Component)Component.m_237110_((String)"command.money.balance", (Object[])new Object[]{String.format("%.2f", balance)}));
        return 1;
    }
}

