/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static BlockPos getAttachedContainerPos(Level level, BlockPos signPos, BlockState signState) {
        Direction facing = Direction.NORTH;
        if (signState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            facing = (Direction)signState.m_61143_((Property)BlockStateProperties.f_61374_);
            LOGGER.debug("Wandschild Richtung: {}", (Object)facing);
        } else if (signState.m_61138_((Property)BlockStateProperties.f_61390_)) {
            int rotation = (Integer)signState.m_61143_((Property)BlockStateProperties.f_61390_);
            facing = Direction.m_122407_((int)(rotation * 16 / 360));
            LOGGER.debug("Bodenschild Rotation: {} => Richtung: {}", (Object)rotation, (Object)facing);
        }
        BlockPos containerPos = signPos.m_121945_(facing.m_122424_());
        LOGGER.info("Erwartete Container Position: {}", (Object)containerPos);
        return containerPos;
    }

    public static MutableComponent getFirstItemName(Level level, BlockPos containerPos) {
        BlockEntity be = level.m_7702_(containerPos);
        LOGGER.debug("BlockEntity an {}: {}", (Object)containerPos, (Object)be);
        MutableComponent line = Component.m_237113_((String)"Air").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        if (be instanceof Container) {
            Container container = (Container)be;
            LOGGER.info("Container gefunden: {} mit {} Slots", (Object)be.getClass().getSimpleName(), (Object)container.m_6643_());
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_()) continue;
                LOGGER.info("Gefundenes Item in Slot {}: {} (x{})", (Object)i, (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), (Object)stack.m_41613_());
                return stack.m_41786_().m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
            }
            LOGGER.debug("Container ist leer");
        } else {
            LOGGER.warn("Kein Container an {}", (Object)containerPos);
        }
        return line;
    }
}

