/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.handlers.ContainerHandler;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ShopSignHandler {
    public static void handleSignInteraction(UUID ownerUUID, Player customer, String itemName, double price, String type, BlockPos signPos) {
        if (!(customer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverCustomer = (ServerPlayer)customer;
        Level level = customer.m_9236_();
        BlockState signState = level.m_8055_(signPos);
        BlockPos containerPos = ContainerHandler.getAttachedContainerPos(level, signPos, signState);
        BlockEntity blockEntity = level.m_7702_(containerPos);
        if (!(blockEntity instanceof Container)) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.no_container").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return;
        }
        Container container = (Container)blockEntity;
        if (type.equalsIgnoreCase("buy")) {
            ShopSignHandler.handleBuyInteraction(ownerUUID, serverCustomer, itemName, price, container);
        } else if (type.equalsIgnoreCase("sell")) {
            ShopSignHandler.handleSellInteraction(ownerUUID, serverCustomer, itemName, price, container);
        }
    }

    private static void handleBuyInteraction(UUID ownerUUID, ServerPlayer customer, String itemName, double price, Container container) {
        double customerBalance = BalanceManager.getPlayerBalance(customer);
        if (customerBalance < price) {
            customer.m_213846_((Component)Component.m_237110_((String)"shop.error.not_enough_money", (Object[])new Object[]{String.format("%.2f", price)}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return;
        }
        ItemStack itemToTransfer = null;
        int containerSlot = -1;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41786_().getString().equals(itemName)) continue;
            itemToTransfer = stack.m_41777_();
            containerSlot = i;
            break;
        }
        if (itemToTransfer == null || containerSlot == -1) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.item_not_available").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return;
        }
        ItemStack singleItem = itemToTransfer.m_41777_();
        singleItem.m_41764_(1);
        if (!ShopSignHandler.hasInventorySpace(customer.m_150109_(), singleItem)) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.inventory_full").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return;
        }
        BalanceManager.updatePlayerBalance(customer, customerBalance - price);
        String ownerUUIDString = ownerUUID.toString();
        double ownerBalance = BalanceManager.getBalance(ownerUUIDString);
        BalanceManager.setBalance(ownerUUIDString, ownerBalance + price);
        ItemStack containerStack = container.m_8020_(containerSlot);
        containerStack.m_41774_(1);
        container.m_6836_(containerSlot, containerStack);
        customer.m_150109_().m_36054_(singleItem);
        customer.m_213846_((Component)Component.m_237110_((String)"shop.buy.success", (Object[])new Object[]{itemName, String.format("%.2f", price)}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
        ServerPlayer owner = customer.m_20194_().m_6846_().m_11259_(ownerUUID);
        if (owner != null) {
            owner.m_213846_((Component)Component.m_237110_((String)"shop.buy.owner_notification", (Object[])new Object[]{customer.m_5446_().getString(), itemName, String.format("%.2f", price)}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
        }
    }

    private static void handleSellInteraction(UUID ownerUUID, ServerPlayer customer, String itemName, double price, Container container) {
        String ownerUUIDString = ownerUUID.toString();
        double ownerBalance = BalanceManager.getBalance(ownerUUIDString);
        if (ownerBalance < price) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.owner_not_enough_money").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return;
        }
        ItemStack itemToSell = null;
        int inventorySlot = -1;
        Inventory inventory = customer.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41786_().getString().equals(itemName)) continue;
            itemToSell = stack.m_41777_();
            inventorySlot = i;
            break;
        }
        if (itemToSell == null || inventorySlot == -1) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.item_not_in_inventory").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return;
        }
        ItemStack singleItem = itemToSell.m_41777_();
        singleItem.m_41764_(1);
        if (!ShopSignHandler.hasContainerSpace(container, singleItem)) {
            customer.m_213846_((Component)Component.m_237115_((String)"shop.error.container_full").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return;
        }
        BalanceManager.setBalance(ownerUUIDString, ownerBalance - price);
        double customerBalance = BalanceManager.getPlayerBalance(customer);
        BalanceManager.updatePlayerBalance(customer, customerBalance + price);
        ItemStack inventoryStack = inventory.m_8020_(inventorySlot);
        inventoryStack.m_41774_(1);
        inventory.m_6836_(inventorySlot, inventoryStack);
        ShopSignHandler.addItemToContainer(container, singleItem);
        customer.m_213846_((Component)Component.m_237110_((String)"shop.sell.success", (Object[])new Object[]{itemName, String.format("%.2f", price)}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
        ServerPlayer owner = customer.m_20194_().m_6846_().m_11259_(ownerUUID);
        if (owner != null) {
            owner.m_213846_((Component)Component.m_237110_((String)"shop.sell.owner_notification", (Object[])new Object[]{customer.m_5446_().getString(), itemName, String.format("%.2f", price)}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
        }
    }

    private static boolean hasInventorySpace(Inventory inventory, ItemStack itemStack) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.m_41613_() >= stack.m_41741_()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasContainerSpace(Container container, ItemStack itemStack) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.m_41613_() >= stack.m_41741_()) continue;
            return true;
        }
        return false;
    }

    private static void addItemToContainer(Container container, ItemStack itemStack) {
        int i;
        for (i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.m_41613_() >= stack.m_41741_()) continue;
            stack.m_41769_(1);
            container.m_6836_(i, stack);
            return;
        }
        for (i = 0; i < container.m_6643_(); ++i) {
            if (!container.m_8020_(i).m_41619_()) continue;
            container.m_6836_(i, itemStack);
            return;
        }
    }
}

