/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Paycheck {
    private static long lastPaycheckTime = 0L;
    private static final long PAYCHECK_INTERVAL = TimeUnit.MINUTES.toMillis(30L);

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new Paycheck());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = event.getServer();
        long currentTime = System.currentTimeMillis();
        if (Config.PAYCHECK_ENABLED && currentTime - lastPaycheckTime >= PAYCHECK_INTERVAL) {
            lastPaycheckTime = currentTime;
            this.payPlayers(server);
        }
    }

    private void payPlayers(MinecraftServer server) {
        List players = server.m_6846_().m_11314_();
        for (ServerPlayer player : players) {
            String playerUUID = player.m_20148_().toString();
            int paycheckAmount = Config.PAYCHECK_AMOUNT;
            BalanceManager.addMoneyToPlayer(server, playerUUID, paycheckAmount);
            player.m_213846_((Component)Component.m_237110_((String)"message.sarosmoneymod.paycheck", (Object[])new Object[]{paycheckAmount}));
        }
    }
}

