/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class LeaderboardCommand {
    private static LeaderboardData leaderboardData;

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"leaderboard").then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> LeaderboardCommand.createLeaderboard((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))).then(Commands.m_82127_((String)"delete").executes(LeaderboardCommand::deleteLeaderboards)));
    }

    private static int createLeaderboard(CommandContext<CommandSourceStack> context, int number) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer player = source.m_81375_();
            ServerLevel world = player.m_183503_();
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            BlockPos position = player.m_142538_();
            Leaderboard newLeaderboard = new Leaderboard(position, number);
            leaderboardData.addLeaderboard(newLeaderboard);
            LeaderboardCommand.updateLeaderboard((Level)world, newLeaderboard);
            leaderboardData.m_77762_();
            source.m_81354_((Component)new TextComponent("\u00a7aLeaderboard created successfully."), true);
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)new TextComponent("\u00a7cFailed to create leaderboard."));
            e.printStackTrace();
        }
        return 1;
    }

    private static int deleteLeaderboards(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer player = source.m_81375_();
            ServerLevel world = player.m_183503_();
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            BlockPos playerPos = player.m_142538_();
            int radius = 5;
            List toRemove = leaderboardData.getLeaderboards().stream().filter(lb -> lb.getPosition().m_123314_((Vec3i)playerPos, (double)radius)).collect(Collectors.toList());
            for (Leaderboard leaderboard : toRemove) {
                leaderboard.getArmorStands().forEach(armorStand -> {
                    if (armorStand != null && !armorStand.m_146910_()) {
                        armorStand.m_6074_();
                    }
                });
                leaderboardData.removeLeaderboard(leaderboard);
            }
            leaderboardData.m_77762_();
            source.m_81354_((Component)new TextComponent("\u00a7aLeaderboards deleted successfully."), true);
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)new TextComponent("\u00a7cFailed to delete leaderboards."));
            e.printStackTrace();
        }
        return 1;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        ServerLevel world;
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.END && (server = ServerLifecycleHooks.getCurrentServer()) != null && (world = server.m_129880_(Level.f_46428_)) != null) {
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            if (leaderboardData != null) {
                for (Leaderboard leaderboard : leaderboardData.getLeaderboards()) {
                    LeaderboardCommand.updateLeaderboard((Level)world, leaderboard);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ArmorStand && event.getWorld() instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)event.getWorld();
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            ArmorStand armorStand = (ArmorStand)event.getEntity();
            BlockPos armorStandPos = armorStand.m_142538_();
            leaderboardData.getLeaderboards().forEach(leaderboard -> {
                if (leaderboard.getPosition().equals((Object)armorStandPos)) {
                    leaderboard.addArmorStand(armorStand);
                }
            });
        }
    }

    private static void updateLeaderboard(Level world, Leaderboard leaderboard) {
        Map<String, Double> balances = BalanceManager.loadBalances(world.m_142572_());
        List sortedBalances = balances.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(leaderboard.getSize()).collect(Collectors.toList());
        ArrayList<CallSite> leaderboardLines = new ArrayList<CallSite>();
        int i = 1;
        for (Map.Entry entry : sortedBalances) {
            try {
                UUID playerUUID = UUID.fromString((String)entry.getKey());
                Optional profile = world.m_142572_().m_129927_().m_11002_(playerUUID);
                String playerName = profile.map(GameProfile::getName).orElse("Unknown Player");
                leaderboardLines.add((CallSite)((Object)(i + ". " + playerName + ": " + String.format("%.2f", entry.getValue()))));
                ++i;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid UUID string: " + (String)entry.getKey());
            }
        }
        leaderboard.getArmorStands().forEach(armorStand -> {
            if (armorStand != null && !armorStand.m_146910_()) {
                armorStand.m_6074_();
            }
        });
        leaderboard.clearArmorStands();
        BlockPos position = leaderboard.getPosition();
        for (int j = 0; j < leaderboardLines.size(); ++j) {
            String line = (String)leaderboardLines.get(j);
            ArmorStand armorStand2 = new ArmorStand(world, (double)position.m_123341_(), (double)position.m_123342_() - (double)j * 0.25, (double)position.m_123343_());
            armorStand2.m_6842_(true);
            armorStand2.m_6593_((Component)new TextComponent(line));
            armorStand2.m_20340_(true);
            armorStand2.m_20242_(true);
            world.m_7967_((Entity)armorStand2);
            leaderboard.addArmorStand(armorStand2);
        }
    }

    private static class LeaderboardData
    extends SavedData {
        private static final String DATA_NAME = "leaderboard_data";
        private final List<Leaderboard> leaderboards = new ArrayList<Leaderboard>();

        private LeaderboardData() {
        }

        public List<Leaderboard> getLeaderboards() {
            return this.leaderboards;
        }

        public void addLeaderboard(Leaderboard leaderboard) {
            this.leaderboards.add(leaderboard);
        }

        public void removeLeaderboard(Leaderboard leaderboard) {
            this.leaderboards.remove(leaderboard);
        }

        public CompoundTag m_7176_(CompoundTag compound) {
            ListTag tags = new ListTag();
            this.leaderboards.stream().map(Leaderboard::toTag).forEach(arg_0 -> tags.add(arg_0));
            compound.m_128365_("leaderboards", (Tag)tags);
            return compound;
        }

        public static LeaderboardData load(ServerLevel world) {
            return (LeaderboardData)world.m_8895_().m_164861_(nbt -> {
                LeaderboardData data = new LeaderboardData();
                if (nbt != null && nbt.m_128425_("leaderboards", 9)) {
                    ListTag tags = nbt.m_128437_("leaderboards", 10);
                    tags.forEach(tag -> data.addLeaderboard(Leaderboard.fromTag((CompoundTag)tag)));
                }
                return data;
            }, LeaderboardData::new, DATA_NAME);
        }
    }

    private static class Leaderboard {
        private final BlockPos position;
        private final int size;
        private final List<ArmorStand> armorStands;

        public Leaderboard(BlockPos position, int size) {
            this.position = position;
            this.size = size;
            this.armorStands = new ArrayList<ArmorStand>();
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public int getSize() {
            return this.size;
        }

        public List<ArmorStand> getArmorStands() {
            return this.armorStands;
        }

        public void addArmorStand(ArmorStand armorStand) {
            this.armorStands.add(armorStand);
        }

        public void clearArmorStands() {
            this.armorStands.clear();
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", this.position.m_123341_());
            tag.m_128405_("y", this.position.m_123342_());
            tag.m_128405_("z", this.position.m_123343_());
            tag.m_128405_("size", this.size);
            return tag;
        }

        public static Leaderboard fromTag(CompoundTag tag) {
            BlockPos pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
            int size = tag.m_128451_("size");
            return new Leaderboard(pos, size);
        }
    }
}

