/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PayCommand {
    private static final SuggestionProvider<CommandSourceStack> PLAYER_NAMES = (context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)((CommandSourceStack)context.getSource()).m_5982_(), (SuggestionsBuilder)builder);

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"pay").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAMES).then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(PayCommand::pay))));
    }

    private static int pay(CommandContext<CommandSourceStack> context) {
        ServerPlayer sender;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            sender = source.m_81375_();
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)new TranslatableComponent("command.pay.sender_not_player"));
            return 0;
        }
        String targetPlayerName = StringArgumentType.getString(context, (String)"player");
        double amount = DoubleArgumentType.getDouble(context, (String)"amount");
        MinecraftServer server = source.m_81377_();
        String senderUUID = sender.m_142081_().toString();
        double senderBalance = BalanceManager.getBalance(senderUUID);
        if (senderBalance < amount) {
            sender.m_6352_((Component)new TranslatableComponent("command.pay.not_enough_money"), sender.m_142081_());
            return 0;
        }
        ServerPlayer targetPlayer = server.m_6846_().m_11255_(targetPlayerName);
        if (targetPlayer == null) {
            sender.m_6352_((Component)new TranslatableComponent("command.pay.player_not_found"), sender.m_142081_());
            return 0;
        }
        String targetUUID = targetPlayer.m_142081_().toString();
        double targetBalance = BalanceManager.getBalance(targetUUID);
        BalanceManager.setBalance(senderUUID, senderBalance - amount);
        BalanceManager.setBalance(targetUUID, targetBalance + amount);
        sender.m_6352_((Component)new TranslatableComponent("command.pay.success_sender", new Object[]{String.format("%.2f", amount), targetPlayerName}), sender.m_142081_());
        targetPlayer.m_6352_((Component)new TranslatableComponent("command.pay.success_receiver", new Object[]{String.format("%.2f", amount), sender.m_7755_().getString()}), sender.m_142081_());
        return 1;
    }
}

