/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class BalanceData
extends SavedData {
    private static final String DATA_NAME = "sarosmoneymod_balance";
    private final Map<String, Double> balances = new HashMap<String, Double>();

    public static BalanceData load(CompoundTag compound) {
        BalanceData data = new BalanceData();
        if (compound.m_128425_("balances", 10)) {
            CompoundTag mapTag = compound.m_128469_("balances");
            for (String key : mapTag.m_128431_()) {
                if (mapTag.m_128425_(key, 6)) {
                    data.balances.put(key, mapTag.m_128459_(key));
                    continue;
                }
                data.balances.put(key, Double.valueOf(mapTag.m_128451_(key)));
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<String, Double> entry : this.balances.entrySet()) {
            mapTag.m_128347_(entry.getKey(), entry.getValue().doubleValue());
        }
        compound.m_128365_("balances", (Tag)mapTag);
        return compound;
    }

    public double getBalance(String playerUUID) {
        return this.balances.getOrDefault(playerUUID, 0.0);
    }

    public boolean containsBalance(String playerUUID) {
        return this.balances.containsKey(playerUUID);
    }

    public void setBalance(String playerUUID, double balance) {
        this.balances.put(playerUUID, balance);
        this.m_77762_();
    }

    public Map<String, Double> getAllBalances() {
        return new HashMap<String, Double>(this.balances);
    }

    public static BalanceData get(MinecraftServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Server instance is null");
        }
        ServerLevel level = server.m_129783_();
        return (BalanceData)level.m_8895_().m_164861_(BalanceData::load, BalanceData::new, DATA_NAME);
    }
}

