/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import de.sarocesch.sarosmoneymod.data.BalanceData;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BalanceManager {
    public static void addMoneyToPlayer(MinecraftServer server, String playerUUID, double amount) {
        double current = BalanceManager.getBalance(playerUUID);
        BalanceManager.setBalance(playerUUID, current + amount);
    }

    public static Map<String, Double> loadBalances(MinecraftServer server) {
        return BalanceData.get(server).getAllBalances();
    }

    public static double getPlayerBalance(ServerPlayer player) {
        return BalanceManager.getBalance(player.m_142081_().toString());
    }

    public static void updatePlayerBalance(ServerPlayer player, double newBalance) {
        BalanceManager.setBalance(player.m_142081_().toString(), newBalance);
    }

    public static double getBalance(String playerUUID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return 0.0;
        }
        BalanceData data = BalanceData.get(server);
        return data.getBalance(playerUUID);
    }

    public static void setBalance(String playerUUID, double balance) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        BalanceData data = BalanceData.get(server);
        data.setBalance(playerUUID, balance);
    }
}

