/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handleSignUpdate(ServerPlayer player, BlockPos signPos) {
        ServerLevel level = player.m_183503_();
        BlockEntity blockEntity = level.m_7702_(signPos);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            LOGGER.info("[Shop] Processing sign update at {}", (Object)signPos);
            BlockState signState = level.m_8055_(signPos);
            BlockPos containerPos = ServerHandler.calculateContainerPos(signPos, signState);
            MutableComponent itemName = ServerHandler.getItemName((Level)level, containerPos);
            ServerHandler.updateSignText(sign, containerPos, itemName);
            ServerHandler.syncSignWithClient((Level)level, signPos, sign);
        }
    }

    private static BlockPos calculateContainerPos(BlockPos signPos, BlockState state) {
        Direction facing = Direction.NORTH;
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return signPos.m_142300_(facing.m_122424_());
    }

    private static MutableComponent getItemName(Level level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof Container) {
            Container container = (Container)be;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_()) continue;
                return stack.m_41786_().m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
            }
        }
        return new TextComponent("Air").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
    }

    private static void updateSignText(SignBlockEntity sign, BlockPos containerPos, MutableComponent itemName) {
        Component[] lines = new Component[4];
        for (int i = 0; i < 4; ++i) {
            lines[i] = sign.m_155706_(i, false);
        }
        String firstLine = lines[0].getString().trim().toLowerCase();
        boolean isBuy = firstLine.equals("[buy]");
        boolean isSell = firstLine.equals("[sell]");
        if (isBuy || isSell) {
            MutableComponent priceLine;
            ChatFormatting color = isBuy ? ChatFormatting.BLUE : ChatFormatting.GOLD;
            MutableComponent line1 = new TextComponent(firstLine.toUpperCase()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(color));
            try {
                String priceText = lines[3].getString().trim();
                double price = Double.parseDouble(priceText);
                priceLine = new TextComponent(String.format("$%.2f", price)).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(color));
            }
            catch (NumberFormatException e) {
                priceLine = new TextComponent("Invalid Price").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.RED));
            }
            sign.m_59732_(0, (Component)line1);
            sign.m_59732_(1, lines[1]);
            sign.m_59732_(2, (Component)itemName);
            sign.m_59732_(3, (Component)priceLine);
            LOGGER.info("[Shop] Updated sign layout");
        }
    }

    private static void syncSignWithClient(Level level, BlockPos pos, SignBlockEntity sign) {
        sign.m_6596_();
        level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 3);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)sign);
            for (Player player : serverLevel.m_6907_()) {
                ServerPlayer serverPlayer;
                if (!(player instanceof ServerPlayer) || !((serverPlayer = (ServerPlayer)player).m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) < 4096.0)) continue;
                serverPlayer.f_8906_.m_141995_((Packet)packet);
            }
        }
    }
}

