/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.SarosMoneyModMod;
import de.sarocesch.sarosmoneymod.handlers.ShopSignHandler;
import de.sarocesch.sarosmoneymod.network.NetworkHandler;
import de.sarocesch.sarosmoneymod.network.SignUpdatePacket;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="saros__money_mod")
public class SignShopListener {
    private static Field signField;
    private static SignEditScreen lastSignScreen;
    private static BlockPos lastSignPos;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            SignEditScreen signScreen;
            Minecraft minecraft = Minecraft.m_91087_();
            Screen currentScreen = minecraft.f_91080_;
            if (lastSignScreen != null && !(currentScreen instanceof SignEditScreen)) {
                BlockPos signPos = lastSignPos;
                if (signPos != null) {
                    new Thread(() -> {
                        try {
                            Thread.sleep(500L);
                            NetworkHandler.INSTANCE.sendToServer((Object)new SignUpdatePacket(signPos));
                        }
                        catch (Exception e) {
                            SarosMoneyModMod.LOGGER.error("Sign update failed:", (Throwable)e);
                        }
                    }).start();
                }
                lastSignScreen = null;
                lastSignPos = null;
            }
            if (currentScreen instanceof SignEditScreen && (signScreen = (SignEditScreen)currentScreen) != lastSignScreen) {
                try {
                    SignBlockEntity sign = (SignBlockEntity)signField.get(signScreen);
                    lastSignPos = sign.m_58899_();
                    lastSignScreen = signScreen;
                }
                catch (Exception e) {
                    SarosMoneyModMod.LOGGER.error("Failed to update sign reference:", (Throwable)e);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSignPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            BlockPos signPos;
            Player player = (Player)entity;
            Level level = (Level)event.getWorld();
            BlockEntity blockEntity = level.m_7702_(signPos = event.getPos());
            if (blockEntity instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                CompoundTag nbt = sign.getTileData();
                nbt.m_128362_("OwnerUUID", player.m_142081_());
                BlockState signState = level.m_8055_(sign.m_58899_());
                if (signState.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    Direction facing = (Direction)signState.m_61143_((Property)BlockStateProperties.f_61374_);
                    BlockPos containerPos = signPos.m_142300_(facing.m_122424_());
                    nbt.m_128385_("ContainerPos", new int[]{containerPos.m_123341_(), containerPos.m_123342_(), containerPos.m_123343_()});
                }
                sign.m_6596_();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        UUID ownerUUID;
        BlockEntity nbt;
        SignBlockEntity sign;
        Player player = event.getPlayer();
        Level level = player.f_19853_;
        BlockPos pos = event.getPos();
        if (level.m_7702_(pos) instanceof Container && (sign = SignShopListener.findLinkedSign(level, pos)) != null && (nbt = sign.getTileData()).m_128441_("OwnerUUID")) {
            ownerUUID = nbt.m_128342_("OwnerUUID");
            if (!player.m_142081_().equals(ownerUUID) && !player.m_7500_()) {
                event.setCanceled(true);
                player.m_5661_((Component)new TranslatableComponent("shop.protection.container_owner_only").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))), true);
            }
        }
        if ((nbt = level.m_7702_(pos)) instanceof SignBlockEntity && (nbt = (sign = (SignBlockEntity)nbt).getTileData()).m_128441_("OwnerUUID")) {
            ownerUUID = nbt.m_128342_("OwnerUUID");
            if (!player.m_142081_().equals(ownerUUID) && !player.m_7500_()) {
                event.setCanceled(true);
                player.m_5661_((Component)new TranslatableComponent("shop.protection.sign_owner_only").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        Level level = event.getWorld();
        BlockPos pos = event.getPos();
        if (!level.m_5776_()) {
            UUID ownerUUID;
            BlockEntity nbt;
            SignBlockEntity sign;
            if (level.m_7702_(pos) instanceof Container && (sign = SignShopListener.findLinkedSign(level, pos)) != null && (nbt = sign.getTileData()).m_128441_("OwnerUUID")) {
                ownerUUID = nbt.m_128342_("OwnerUUID");
                if (!player.m_142081_().equals(ownerUUID)) {
                    event.setCanceled(true);
                    player.m_5661_((Component)new TranslatableComponent("shop.protection.container_use_owner_only").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))), true);
                    return;
                }
            }
            if ((nbt = level.m_7702_(pos)) instanceof SignBlockEntity) {
                Component[] signMessages;
                sign = (SignBlockEntity)nbt;
                ownerUUID = (nbt = sign.getTileData()).m_128441_("OwnerUUID") ? nbt.m_128342_("OwnerUUID") : null;
                try {
                    Method getMessagesMethod = SignBlockEntity.class.getDeclaredMethod("getMessages", Boolean.TYPE);
                    getMessagesMethod.setAccessible(true);
                    signMessages = (Component[])getMessagesMethod.invoke((Object)sign, false);
                }
                catch (Exception e) {
                    return;
                }
                String[] lines = new String[4];
                for (int i = 0; i < 4; ++i) {
                    lines[i] = signMessages[i].getString().trim();
                }
                String type = null;
                String itemId = null;
                String priceStr = null;
                if (lines[0].equalsIgnoreCase("[shop]")) {
                    type = lines[1].toLowerCase();
                    itemId = lines[2];
                    priceStr = lines[3];
                } else if (lines[0].equalsIgnoreCase("[buy]") || lines[0].equalsIgnoreCase("[sell]")) {
                    type = lines[0].substring(1, lines[0].length() - 1).toLowerCase();
                    if (lines[1].isEmpty() && !lines[3].isEmpty()) {
                        itemId = lines[2];
                        priceStr = lines[3];
                    } else {
                        itemId = lines[1];
                        priceStr = lines[2];
                    }
                } else {
                    return;
                }
                if (!type.equals("buy") && !type.equals("sell")) {
                    player.m_5661_((Component)new TranslatableComponent("shop.error.invalid_shop_type").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    return;
                }
                try {
                    double priceValue;
                    double price = priceValue = Double.parseDouble(priceStr.replaceAll("[^0-9.,]", "").replace(',', '.'));
                    Item item = (Item)Registry.f_122827_.m_7745_(ResourceLocation.m_135820_((String)itemId.toLowerCase()));
                    ShopSignHandler.handleSignInteraction(ownerUUID, player, item.m_41466_().getString(), price, type, pos);
                }
                catch (NumberFormatException e) {
                    player.m_5661_((Component)new TranslatableComponent("shop.error.invalid_price_format").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
            }
        }
    }

    private static SignBlockEntity findLinkedSign(Level level, BlockPos containerPos) {
        for (BlockPos pos : BlockPos.m_121925_((BlockPos)containerPos, (int)5, (int)5, (int)5)) {
            int[] coords;
            BlockPos linkedPos;
            SignBlockEntity sign;
            CompoundTag nbt;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof SignBlockEntity) || !(nbt = (sign = (SignBlockEntity)blockEntity).getTileData()).m_128441_("ContainerPos") || !(linkedPos = new BlockPos((coords = nbt.m_128465_("ContainerPos"))[0], coords[1], coords[2])).equals((Object)containerPos)) continue;
            return sign;
        }
        return null;
    }

    static {
        lastSignScreen = null;
        lastSignPos = null;
        try {
            signField = SignEditScreen.class.getDeclaredField("sign");
            signField.setAccessible(true);
        }
        catch (Exception e) {
            SarosMoneyModMod.LOGGER.error("Reflection error:", (Throwable)e);
        }
    }
}

