/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.procedures;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WithdrawProcedure {
    public static void execute(Entity entity, HashMap guistate, String withdrawValue, ServerPlayer player) {
        Player _player;
        if (entity == null || guistate == null) {
            return;
        }
        if (entity instanceof Player && !(_player = (Player)entity).m_183503_().m_5776_()) {
            try {
                int amount = Integer.parseInt(withdrawValue);
                if (amount > 0) {
                    String playerUUID = _player.m_142081_().toString();
                    double currentBalance = BalanceManager.getBalance(playerUUID);
                    if ((double)amount <= currentBalance) {
                        Map<Integer, ItemStack> items = WithdrawProcedure.convertAmountToItems(amount);
                        boolean canFitAllItems = WithdrawProcedure.canFitItems(_player, items);
                        if (canFitAllItems) {
                            WithdrawProcedure.addItemsToPlayerInventory(_player, items);
                            double newBalance = currentBalance - (double)amount;
                            BalanceManager.setBalance(playerUUID, newBalance);
                            _player.m_5661_((Component)new TextComponent("\u00a79").m_7220_((Component)new TranslatableComponent("lang.withdraw.previous_balance")).m_7220_((Component)new TextComponent(" " + currentBalance)), false);
                            _player.m_5661_((Component)new TextComponent("\u00a7a").m_7220_((Component)new TranslatableComponent("lang.withdraw.withdrawn_amount")).m_7220_((Component)new TextComponent(" " + amount)), false);
                            _player.m_5661_((Component)new TextComponent("\u00a76").m_7220_((Component)new TranslatableComponent("lang.withdraw.new_balance")).m_7220_((Component)new TextComponent(" " + newBalance)), false);
                            ((EditBox)guistate.get("text:withdraw")).m_94144_("");
                        } else {
                            _player.m_5661_((Component)new TextComponent("\u00a7c").m_7220_((Component)new TranslatableComponent("lang.withdraw.not_enough_inventory")), false);
                        }
                    } else {
                        _player.m_5661_((Component)new TextComponent("\u00a7c").m_7220_((Component)new TranslatableComponent("lang.withdraw.not_enough_balance")), false);
                    }
                } else {
                    _player.m_5661_((Component)new TextComponent("\u00a7c").m_7220_((Component)new TranslatableComponent("lang.withdraw.enter_positive_number")), false);
                }
            }
            catch (NumberFormatException e) {
                _player.m_5661_((Component)new TextComponent("\u00a7c").m_7220_((Component)new TranslatableComponent("lang.withdraw.enter_valid_number")), false);
            }
        }
    }

    private static Map<Integer, ItemStack> convertAmountToItems(int amount) {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        int remaining = amount;
        int[] denominations = new int[]{500, 200, 100, 50, 20, 10, 5, 2, 1};
        ItemStack[] itemStacks = new ItemStack[]{new ItemStack((ItemLike)SarosMoneyModModItems.EURO_500.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_200.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_100.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_50.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_20.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_10.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_5.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_2.get()), new ItemStack((ItemLike)SarosMoneyModModItems.EURO_1.get())};
        for (int i = 0; i < denominations.length; ++i) {
            int denom = denominations[i];
            int count = remaining / denom;
            if (count <= 0) continue;
            ItemStack stack = itemStacks[i].m_41777_();
            stack.m_41764_(count);
            items.put(denom, stack);
            remaining %= denom;
        }
        return items;
    }

    private static boolean canFitItems(Player player, Map<Integer, ItemStack> items) {
        int freeSlots = 0;
        int slotsNeeded = 0;
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            if (!((ItemStack)player.m_150109_().f_35974_.get(i)).m_41619_()) continue;
            ++freeSlots;
        }
        for (ItemStack stack : items.values()) {
            int remainingCount = stack.m_41613_();
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                int spaceInStack;
                ItemStack invStack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (invStack.m_41619_() || !ItemStack.m_150942_((ItemStack)invStack, (ItemStack)stack) || (remainingCount -= (spaceInStack = invStack.m_41741_() - invStack.m_41613_())) > 0) continue;
                remainingCount = 0;
                break;
            }
            slotsNeeded += (remainingCount + stack.m_41741_() - 1) / stack.m_41741_();
        }
        return freeSlots >= slotsNeeded;
    }

    private static void addItemsToPlayerInventory(Player player, Map<Integer, ItemStack> items) {
        for (ItemStack stack : items.values()) {
            while (!stack.m_41619_()) {
                int remainingCount = stack.m_41613_();
                for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                    ItemStack invStack = (ItemStack)player.m_150109_().f_35974_.get(i);
                    if (invStack.m_41619_() || !ItemStack.m_150942_((ItemStack)invStack, (ItemStack)stack)) continue;
                    int spaceInStack = invStack.m_41741_() - invStack.m_41613_();
                    if (remainingCount <= spaceInStack) {
                        invStack.m_41769_(remainingCount);
                        stack.m_41764_(0);
                        break;
                    }
                    invStack.m_41769_(spaceInStack);
                    remainingCount -= spaceInStack;
                }
                if (stack.m_41619_()) continue;
                player.m_36356_(stack.m_41620_(stack.m_41741_()));
            }
        }
    }
}

