/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EcoCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"eco").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ISuggestionProvider.func_197005_b(EcoCommand.getOnlinePlayerNames((CommandContext<CommandSource>)context), (SuggestionsBuilder)builder)).then(Commands.func_197056_a((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(context -> EcoCommand.addBalance((CommandContext<CommandSource>)context)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ISuggestionProvider.func_197005_b(EcoCommand.getOnlinePlayerNames((CommandContext<CommandSource>)context), (SuggestionsBuilder)builder)).then(Commands.func_197056_a((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> EcoCommand.setBalance((CommandContext<CommandSource>)context)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"take").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ISuggestionProvider.func_197005_b(EcoCommand.getOnlinePlayerNames((CommandContext<CommandSource>)context), (SuggestionsBuilder)builder)).then(Commands.func_197056_a((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(context -> EcoCommand.takeBalance((CommandContext<CommandSource>)context)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ISuggestionProvider.func_197005_b(EcoCommand.getOnlinePlayerNames((CommandContext<CommandSource>)context), (SuggestionsBuilder)builder)).executes(context -> EcoCommand.getBalance((CommandContext<CommandSource>)context)))));
    }

    private static int addBalance(CommandContext<CommandSource> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        double amount = DoubleArgumentType.getDouble(context, (String)"amount");
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_152612_a(playerName);
        if (player != null) {
            double currentBalance = BalanceManager.getPlayerBalance(player);
            double newBalance = currentBalance + amount;
            BalanceManager.updatePlayerBalance(player, newBalance);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("\u00a7a").func_230529_a_((ITextComponent)new TranslationTextComponent("command.eco.add.success", new Object[]{String.format("%.2f", amount), playerName, String.format("%.2f", newBalance)})), true);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("\u00a7c").func_230529_a_((ITextComponent)new TranslationTextComponent("command.eco.player_not_found")));
        return 0;
    }

    private static int setBalance(CommandContext<CommandSource> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        double amount = DoubleArgumentType.getDouble(context, (String)"amount");
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_152612_a(playerName);
        if (player != null) {
            BalanceManager.updatePlayerBalance(player, amount);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("\u00a7a").func_230529_a_((ITextComponent)new TranslationTextComponent("command.eco.set.success", new Object[]{String.format("%.2f", amount), playerName})), true);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("\u00a7c").func_230529_a_((ITextComponent)new TranslationTextComponent("command.eco.player_not_found")));
        return 0;
    }

    private static int takeBalance(CommandContext<CommandSource> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        double amount = DoubleArgumentType.getDouble(context, (String)"amount");
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_152612_a(playerName);
        if (player != null) {
            double currentBalance = BalanceManager.getPlayerBalance(player);
            double newBalance = currentBalance - amount;
            BalanceManager.updatePlayerBalance(player, newBalance);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("\u00a7a").func_230529_a_((ITextComponent)new TranslationTextComponent("command.eco.take.success", new Object[]{String.format("%.2f", amount), playerName, String.format("%.2f", newBalance)})), true);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("\u00a7c").func_230529_a_((ITextComponent)new TranslationTextComponent("command.eco.player_not_found")));
        return 0;
    }

    private static int getBalance(CommandContext<CommandSource> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_152612_a(playerName);
        if (player != null) {
            double currentBalance = BalanceManager.getPlayerBalance(player);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("\u00a7a").func_230529_a_((ITextComponent)new TranslationTextComponent("command.eco.get.success", new Object[]{playerName, String.format("%.2f", currentBalance)})), true);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("\u00a7c").func_230529_a_((ITextComponent)new TranslationTextComponent("command.eco.player_not_found")));
        return 0;
    }

    private static List<String> getOnlinePlayerNames(CommandContext<CommandSource> context) {
        return ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_181057_v().stream().map(PlayerEntity::func_146103_bH).map(profile -> profile.getName()).collect(Collectors.toList());
    }
}

