/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class LeaderboardCommand {
    private static LeaderboardData leaderboardData;

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"leaderboard").then(Commands.func_197057_a((String)"create").then(Commands.func_197056_a((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> LeaderboardCommand.createLeaderboard((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))).then(Commands.func_197057_a((String)"delete").executes(LeaderboardCommand::deleteLeaderboards)));
    }

    private static int createLeaderboard(CommandContext<CommandSource> context, int number) {
        CommandSource source = (CommandSource)context.getSource();
        try {
            ServerPlayerEntity player = source.func_197035_h();
            ServerWorld world = player.func_71121_q();
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            BlockPos position = player.func_233580_cy_();
            Leaderboard newLeaderboard = new Leaderboard(position, number);
            leaderboardData.addLeaderboard(newLeaderboard);
            LeaderboardCommand.updateLeaderboard((World)world, newLeaderboard);
            leaderboardData.func_76185_a();
            source.func_197030_a((ITextComponent)new StringTextComponent("\u00a7aLeaderboard created successfully."), true);
        }
        catch (CommandSyntaxException e) {
            source.func_197021_a((ITextComponent)new StringTextComponent("\u00a7cFailed to create leaderboard."));
            e.printStackTrace();
        }
        return 1;
    }

    private static int deleteLeaderboards(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        try {
            ServerPlayerEntity player = source.func_197035_h();
            ServerWorld world = player.func_71121_q();
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            BlockPos playerPos = player.func_233580_cy_();
            int radius = 5;
            List toRemove = leaderboardData.getLeaderboards().stream().filter(lb -> playerPos.func_218141_a((Vector3i)lb.getPosition(), (double)radius)).collect(Collectors.toList());
            for (Leaderboard leaderboard : toRemove) {
                leaderboard.getArmorStands().forEach(armorStand -> {
                    if (armorStand != null && armorStand.func_70089_S()) {
                        armorStand.func_70106_y();
                    }
                });
                leaderboardData.removeLeaderboard(leaderboard);
            }
            leaderboardData.func_76185_a();
            source.func_197030_a((ITextComponent)new StringTextComponent("\u00a7aLeaderboards deleted successfully."), true);
        }
        catch (CommandSyntaxException e) {
            source.func_197021_a((ITextComponent)new StringTextComponent("\u00a7cFailed to delete leaderboards."));
            e.printStackTrace();
        }
        return 1;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        ServerWorld world;
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.END && (server = ServerLifecycleHooks.getCurrentServer()) != null && (world = server.func_71218_a(World.field_234918_g_)) != null) {
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            if (leaderboardData != null) {
                for (Leaderboard leaderboard : leaderboardData.getLeaderboards()) {
                    LeaderboardCommand.updateLeaderboard((World)world, leaderboard);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ArmorStandEntity && event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            ArmorStandEntity armorStand = (ArmorStandEntity)event.getEntity();
            BlockPos armorStandPos = armorStand.func_233580_cy_();
            leaderboardData.getLeaderboards().forEach(leaderboard -> {
                if (leaderboard.getPosition().equals((Object)armorStandPos)) {
                    leaderboard.addArmorStand(armorStand);
                }
            });
        }
    }

    private static void updateLeaderboard(World world, Leaderboard leaderboard) {
        Map<String, Double> balances = BalanceManager.loadBalances(world.func_73046_m());
        List sortedBalances = balances.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(leaderboard.getSize()).collect(Collectors.toList());
        ArrayList<String> leaderboardLines = new ArrayList<String>();
        int i = 1;
        for (Map.Entry entry : sortedBalances) {
            try {
                UUID playerUUID = UUID.fromString((String)entry.getKey());
                GameProfile profile = world.func_73046_m().func_152358_ax().func_152652_a(playerUUID);
                String playerName = profile != null ? profile.getName() : "Unknown Player";
                leaderboardLines.add(i + ". " + playerName + ": " + String.format("%.2f", entry.getValue()));
                ++i;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid UUID string: " + (String)entry.getKey());
            }
        }
        leaderboard.getArmorStands().forEach(armorStand -> {
            if (armorStand != null && armorStand.func_70089_S()) {
                armorStand.func_70106_y();
            }
        });
        leaderboard.clearArmorStands();
        BlockPos position = leaderboard.getPosition();
        for (int j = 0; j < leaderboardLines.size(); ++j) {
            String line = (String)leaderboardLines.get(j);
            ArmorStandEntity armorStand2 = new ArmorStandEntity(world, (double)position.func_177958_n(), (double)position.func_177956_o() - (double)j * 0.25, (double)position.func_177952_p());
            armorStand2.func_82142_c(true);
            armorStand2.func_200203_b((ITextComponent)new StringTextComponent(line));
            armorStand2.func_174805_g(true);
            armorStand2.func_189654_d(true);
            world.func_217376_c((Entity)armorStand2);
            leaderboard.addArmorStand(armorStand2);
        }
    }

    private static class LeaderboardData
    extends WorldSavedData {
        private static final String DATA_NAME = "leaderboard_data";
        private final List<Leaderboard> leaderboards = new ArrayList<Leaderboard>();

        public LeaderboardData() {
            super(DATA_NAME);
        }

        public List<Leaderboard> getLeaderboards() {
            return this.leaderboards;
        }

        public void addLeaderboard(Leaderboard leaderboard) {
            this.leaderboards.add(leaderboard);
        }

        public void removeLeaderboard(Leaderboard leaderboard) {
            this.leaderboards.remove(leaderboard);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.leaderboards.clear();
            if (nbt.func_150297_b("leaderboards", 9)) {
                ListNBT tags = nbt.func_150295_c("leaderboards", 10);
                for (INBT inbt : tags) {
                    this.leaderboards.add(Leaderboard.fromTag((CompoundNBT)inbt));
                }
            }
        }

        public CompoundNBT func_189551_b(CompoundNBT compound) {
            ListNBT tags = new ListNBT();
            for (Leaderboard lb : this.leaderboards) {
                tags.add((Object)lb.toTag());
            }
            compound.func_218657_a("leaderboards", (INBT)tags);
            return compound;
        }

        public static LeaderboardData load(ServerWorld world) {
            return (LeaderboardData)world.func_217481_x().func_215752_a(LeaderboardData::new, DATA_NAME);
        }
    }

    private static class Leaderboard {
        private final BlockPos position;
        private final int size;
        private final List<ArmorStandEntity> armorStands;

        public Leaderboard(BlockPos position, int size) {
            this.position = position;
            this.size = size;
            this.armorStands = new ArrayList<ArmorStandEntity>();
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public int getSize() {
            return this.size;
        }

        public List<ArmorStandEntity> getArmorStands() {
            return this.armorStands;
        }

        public void addArmorStand(ArmorStandEntity armorStand) {
            this.armorStands.add(armorStand);
        }

        public void clearArmorStands() {
            this.armorStands.clear();
        }

        public CompoundNBT toTag() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("x", this.position.func_177958_n());
            tag.func_74768_a("y", this.position.func_177956_o());
            tag.func_74768_a("z", this.position.func_177952_p());
            tag.func_74768_a("size", this.size);
            return tag;
        }

        public static Leaderboard fromTag(CompoundNBT tag) {
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            int size = tag.func_74762_e("size");
            return new Leaderboard(pos, size);
        }
    }
}

