/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MoneyCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.func_197057_a((String)"money").executes(MoneyCommand::showBalance));
    }

    private static int showBalance(CommandContext<CommandSource> context) {
        ServerPlayerEntity player;
        CommandSource source = (CommandSource)context.getSource();
        try {
            player = source.func_197035_h();
        }
        catch (CommandSyntaxException e) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("command.money.not_a_player"));
            return 0;
        }
        String playerUUID = player.func_110124_au().toString();
        Map<String, Double> balances = BalanceManager.loadBalances(source.func_197028_i());
        double balance = balances.getOrDefault(playerUUID, 0.0);
        player.func_145747_a((ITextComponent)new TranslationTextComponent("command.money.balance", new Object[]{String.format("%.2f", balance)}), player.func_110124_au());
        return 1;
    }
}

