/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PayCommand {
    private static final SuggestionProvider<CommandSource> PLAYER_NAMES = (context, builder) -> ISuggestionProvider.func_197005_b((Iterable)((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_181057_v().stream().map(p -> p.func_146103_bH().getName()).collect(Collectors.toList()), (SuggestionsBuilder)builder);

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.func_197057_a((String)"pay").then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAMES).then(Commands.func_197056_a((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(PayCommand::pay))));
    }

    private static int pay(CommandContext<CommandSource> context) {
        ServerPlayerEntity sender;
        CommandSource source = (CommandSource)context.getSource();
        try {
            sender = source.func_197035_h();
        }
        catch (CommandSyntaxException e) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("command.pay.sender_not_player"));
            return 0;
        }
        String targetPlayerName = StringArgumentType.getString(context, (String)"player");
        double amount = DoubleArgumentType.getDouble(context, (String)"amount");
        MinecraftServer server = source.func_197028_i();
        String senderUUID = sender.func_110124_au().toString();
        double senderBalance = BalanceManager.getBalance(senderUUID);
        if (senderBalance < amount) {
            sender.func_145747_a((ITextComponent)new TranslationTextComponent("command.pay.not_enough_money"), sender.func_110124_au());
            return 0;
        }
        ServerPlayerEntity targetPlayer = server.func_184103_al().func_152612_a(targetPlayerName);
        if (targetPlayer == null) {
            sender.func_145747_a((ITextComponent)new TranslationTextComponent("command.pay.player_not_found"), sender.func_110124_au());
            return 0;
        }
        String targetUUID = targetPlayer.func_110124_au().toString();
        double targetBalance = BalanceManager.getBalance(targetUUID);
        BalanceManager.setBalance(senderUUID, senderBalance - amount);
        BalanceManager.setBalance(targetUUID, targetBalance + amount);
        sender.func_145747_a((ITextComponent)new TranslationTextComponent("command.pay.success_sender", new Object[]{String.format("%.2f", amount), targetPlayerName}), sender.func_110124_au());
        targetPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("command.pay.success_receiver", new Object[]{String.format("%.2f", amount), sender.func_145748_c_().getString()}), sender.func_110124_au());
        return 1;
    }
}

