/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class BalanceData
extends WorldSavedData {
    private static final String DATA_NAME = "sarosmoneymod_balance";
    private final Map<String, Double> balances = new HashMap<String, Double>();

    public BalanceData() {
        super(DATA_NAME);
    }

    public BalanceData(String name) {
        super(name);
    }

    public BalanceData(CompoundNBT nbt) {
        this();
        this.func_76184_a(nbt);
    }

    public static BalanceData load(CompoundNBT compound) {
        BalanceData data = new BalanceData();
        if (compound.func_150297_b("balances", 10)) {
            CompoundNBT mapTag = compound.func_74775_l("balances");
            for (String key : mapTag.func_150296_c()) {
                if (mapTag.func_150297_b(key, 6)) {
                    data.balances.put(key, mapTag.func_74769_h(key));
                    continue;
                }
                data.balances.put(key, Double.valueOf(mapTag.func_74762_e(key)));
            }
        }
        return data;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.balances.clear();
        if (nbt.func_150297_b("balances", 10)) {
            CompoundNBT mapTag = nbt.func_74775_l("balances");
            for (String key : mapTag.func_150296_c()) {
                if (mapTag.func_150297_b(key, 6)) {
                    this.balances.put(key, mapTag.func_74769_h(key));
                    continue;
                }
                this.balances.put(key, Double.valueOf(mapTag.func_74762_e(key)));
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT mapTag = new CompoundNBT();
        for (Map.Entry<String, Double> entry : this.balances.entrySet()) {
            mapTag.func_74780_a(entry.getKey(), entry.getValue().doubleValue());
        }
        compound.func_218657_a("balances", (INBT)mapTag);
        return compound;
    }

    public double getBalance(String playerUUID) {
        return this.balances.getOrDefault(playerUUID, 0.0);
    }

    public boolean containsBalance(String playerUUID) {
        return this.balances.containsKey(playerUUID);
    }

    public void setBalance(String playerUUID, double balance) {
        this.balances.put(playerUUID, balance);
        this.func_76185_a();
    }

    public Map<String, Double> getAllBalances() {
        return new HashMap<String, Double>(this.balances);
    }

    public static BalanceData get(MinecraftServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Server instance is null");
        }
        ServerWorld level = server.func_71218_a(World.field_234918_g_);
        return (BalanceData)level.func_217481_x().func_215752_a(BalanceData::new, DATA_NAME);
    }
}

