/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static BlockPos getAttachedContainerPos(World level, BlockPos signPos, BlockState signState) {
        Direction facing = Direction.NORTH;
        if (signState.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            facing = (Direction)signState.func_177229_b((Property)BlockStateProperties.field_208157_J);
            LOGGER.debug("Wandschild Richtung: {}", (Object)facing);
        }
        BlockPos containerPos = signPos.func_177972_a(facing.func_176734_d());
        LOGGER.info("Erwartete Container Position: {}", (Object)containerPos);
        return containerPos;
    }

    public static ITextComponent getFirstItemName(World level, BlockPos containerPos) {
        TileEntity te = level.func_175625_s(containerPos);
        LOGGER.debug("TileEntity an {}: {}", (Object)containerPos, (Object)te);
        IFormattableTextComponent line = new StringTextComponent("Air").func_240699_a_(TextFormatting.BOLD);
        if (te instanceof IInventory) {
            IInventory container = (IInventory)te;
            LOGGER.info("Container gefunden: {} mit {} Slots", (Object)te.getClass().getSimpleName(), (Object)container.func_70302_i_());
            for (int i = 0; i < container.func_70302_i_(); ++i) {
                ItemStack stack = container.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                LOGGER.info("Gefundenes Item in Slot {}: {} (x{})", (Object)i, (Object)ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()), (Object)stack.func_190916_E());
                return stack.func_200301_q().func_230532_e_().func_240699_a_(TextFormatting.BOLD);
            }
            LOGGER.debug("Container ist leer");
        } else {
            LOGGER.warn("Kein Container an {}", (Object)containerPos);
        }
        return line;
    }
}

