/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handleSignUpdate(ServerPlayerEntity player, BlockPos signPos) {
        World world = player.field_70170_p;
        if (world.func_175625_s(signPos) instanceof SignTileEntity) {
            SignTileEntity sign = (SignTileEntity)world.func_175625_s(signPos);
            LOGGER.info("[Shop] Processing sign update at {}", (Object)signPos);
            BlockState signState = world.func_180495_p(signPos);
            BlockPos containerPos = ServerHandler.calculateContainerPos(signPos, signState);
            ITextComponent itemName = ServerHandler.getItemName(world, containerPos);
            ServerHandler.updateSignText(sign, itemName);
            ServerHandler.syncSignWithClient(world, signPos, sign);
        }
    }

    private static BlockPos calculateContainerPos(BlockPos signPos, BlockState state) {
        Direction facing = Direction.NORTH;
        if (state.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        }
        Direction back = facing.func_176734_d();
        return signPos.func_177972_a(back);
    }

    private static ITextComponent getItemName(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            IInventory container = (IInventory)te;
            for (int i = 0; i < container.func_70302_i_(); ++i) {
                ItemStack stack = container.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                return stack.func_200301_q().func_230532_e_().func_240699_a_(TextFormatting.BOLD);
            }
        }
        return new StringTextComponent("Air").func_240699_a_(TextFormatting.BOLD);
    }

    private static void updateSignText(SignTileEntity sign, ITextComponent itemName) {
        ITextComponent line0 = sign.func_212366_a(0);
        ITextComponent line3 = sign.func_212366_a(3);
        String firstLine = line0.getString().trim().toLowerCase();
        boolean isBuy = firstLine.equals("[buy]");
        boolean isSell = firstLine.equals("[sell]");
        if (isBuy || isSell) {
            IFormattableTextComponent priceLine;
            TextFormatting color = isBuy ? TextFormatting.BLUE : TextFormatting.GOLD;
            IFormattableTextComponent line1 = new StringTextComponent(firstLine.toUpperCase()).func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, color});
            try {
                String priceText = line3.getString().trim();
                double price = Double.parseDouble(priceText);
                priceLine = new StringTextComponent(String.format("$%.2f", price)).func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, color});
            }
            catch (NumberFormatException e) {
                priceLine = new StringTextComponent("Invalid Price").func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.RED});
            }
            sign.func_212365_a(0, (ITextComponent)line1);
            sign.func_212365_a(2, itemName);
            sign.func_212365_a(3, (ITextComponent)priceLine);
            LOGGER.info("[Shop] Updated sign layout");
        }
    }

    private static void syncSignWithClient(World world, BlockPos pos, SignTileEntity sign) {
        sign.func_70296_d();
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
    }
}

