/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.handlers.ContainerHandler;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ShopSignHandler {
    public static void handleSignInteraction(UUID ownerUUID, PlayerEntity customer, String itemName, double price, String type, BlockPos signPos) {
        if (!(customer instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity serverCustomer = (ServerPlayerEntity)customer;
        World level = customer.field_70170_p;
        BlockState signState = level.func_180495_p(signPos);
        BlockPos containerPos = ContainerHandler.getAttachedContainerPos(level, signPos, signState);
        TileEntity blockEntity = level.func_175625_s(containerPos);
        if (!(blockEntity instanceof IInventory)) {
            serverCustomer.func_145747_a((ITextComponent)new TranslationTextComponent("shop.error.no_container"), serverCustomer.func_110124_au());
            return;
        }
        IInventory container = (IInventory)blockEntity;
        if (type.equalsIgnoreCase("buy")) {
            ShopSignHandler.handleBuyInteraction(ownerUUID, serverCustomer, itemName, price, container);
        } else if (type.equalsIgnoreCase("sell")) {
            ShopSignHandler.handleSellInteraction(ownerUUID, serverCustomer, itemName, price, container);
        }
    }

    private static void handleBuyInteraction(UUID ownerUUID, ServerPlayerEntity customer, String itemName, double price, IInventory container) {
        double customerBalance = BalanceManager.getPlayerBalance(customer);
        if (customerBalance < price) {
            customer.func_145747_a((ITextComponent)new TranslationTextComponent("shop.error.not_enough_money", new Object[]{String.format("%.2f", price)}).func_240699_a_(TextFormatting.RED), customer.func_110124_au());
            return;
        }
        ItemStack itemToTransfer = null;
        int containerSlot = -1;
        for (int i = 0; i < container.func_70302_i_(); ++i) {
            ItemStack stack = container.func_70301_a(i);
            if (stack.func_190926_b() || !stack.func_200301_q().getString().equals(itemName)) continue;
            itemToTransfer = stack.func_77946_l();
            containerSlot = i;
            break;
        }
        if (itemToTransfer == null || containerSlot == -1) {
            customer.func_145747_a((ITextComponent)new TranslationTextComponent("shop.error.item_not_available").func_240699_a_(TextFormatting.RED), customer.func_110124_au());
            return;
        }
        ItemStack singleItem = itemToTransfer.func_77946_l();
        singleItem.func_190920_e(1);
        if (!ShopSignHandler.hasInventorySpace(customer.field_71071_by, singleItem)) {
            customer.func_145747_a((ITextComponent)new TranslationTextComponent("shop.error.inventory_full").func_240699_a_(TextFormatting.RED), customer.func_110124_au());
            return;
        }
        BalanceManager.updatePlayerBalance(customer, customerBalance - price);
        String ownerUUIDString = ownerUUID.toString();
        double ownerBalance = BalanceManager.getBalance(ownerUUIDString);
        BalanceManager.setBalance(ownerUUIDString, ownerBalance + price);
        ItemStack containerStack = container.func_70301_a(containerSlot);
        containerStack.func_190918_g(1);
        container.func_70299_a(containerSlot, containerStack);
        customer.field_71071_by.func_70441_a(singleItem);
        customer.func_145747_a((ITextComponent)new TranslationTextComponent("shop.buy.success", new Object[]{itemName, String.format("%.2f", price)}).func_240699_a_(TextFormatting.GREEN), customer.func_110124_au());
        ServerPlayerEntity owner = customer.func_184102_h().func_184103_al().func_177451_a(ownerUUID);
        if (owner != null) {
            owner.func_145747_a((ITextComponent)new TranslationTextComponent("shop.buy.owner_notification", new Object[]{customer.func_145748_c_().getString(), itemName, String.format("%.2f", price)}).func_240699_a_(TextFormatting.GREEN), owner.func_110124_au());
        }
    }

    private static void handleSellInteraction(UUID ownerUUID, ServerPlayerEntity customer, String itemName, double price, IInventory container) {
        String ownerUUIDString = ownerUUID.toString();
        double ownerBalance = BalanceManager.getBalance(ownerUUIDString);
        if (ownerBalance < price) {
            customer.func_145747_a((ITextComponent)new TranslationTextComponent("shop.error.owner_not_enough_money").func_240699_a_(TextFormatting.RED), customer.func_110124_au());
            return;
        }
        ItemStack itemToSell = null;
        int inventorySlot = -1;
        PlayerInventory inventory = customer.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !stack.func_200301_q().getString().equals(itemName)) continue;
            itemToSell = stack.func_77946_l();
            inventorySlot = i;
            break;
        }
        if (itemToSell == null || inventorySlot == -1) {
            customer.func_145747_a((ITextComponent)new TranslationTextComponent("shop.error.item_not_in_inventory").func_240699_a_(TextFormatting.RED), customer.func_110124_au());
            return;
        }
        ItemStack singleItem = itemToSell.func_77946_l();
        singleItem.func_190920_e(1);
        if (!ShopSignHandler.hasContainerSpace(container, singleItem)) {
            customer.func_145747_a((ITextComponent)new TranslationTextComponent("shop.error.container_full").func_240699_a_(TextFormatting.RED), customer.func_110124_au());
            return;
        }
        BalanceManager.setBalance(ownerUUIDString, ownerBalance - price);
        double customerBalance = BalanceManager.getPlayerBalance(customer);
        BalanceManager.updatePlayerBalance(customer, customerBalance + price);
        ItemStack inventoryStack = inventory.func_70301_a(inventorySlot);
        inventoryStack.func_190918_g(1);
        inventory.func_70299_a(inventorySlot, inventoryStack);
        ShopSignHandler.addItemToContainer(container, singleItem);
        customer.func_145747_a((ITextComponent)new TranslationTextComponent("shop.sell.success", new Object[]{itemName, String.format("%.2f", price)}).func_240699_a_(TextFormatting.GREEN), customer.func_110124_au());
        ServerPlayerEntity owner = customer.func_184102_h().func_184103_al().func_177451_a(ownerUUID);
        if (owner != null) {
            owner.func_145747_a((ITextComponent)new TranslationTextComponent("shop.sell.owner_notification", new Object[]{customer.func_145748_c_().getString(), itemName, String.format("%.2f", price)}).func_240699_a_(TextFormatting.GREEN), owner.func_110124_au());
        }
    }

    private static boolean hasInventorySpace(PlayerInventory inventory, ItemStack itemStack) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) {
                return true;
            }
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemStack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack) || stack.func_190916_E() >= stack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasContainerSpace(IInventory container, ItemStack itemStack) {
        for (int i = 0; i < container.func_70302_i_(); ++i) {
            ItemStack stack = container.func_70301_a(i);
            if (stack.func_190926_b()) {
                return true;
            }
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemStack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack) || stack.func_190916_E() >= stack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    private static void addItemToContainer(IInventory container, ItemStack itemStack) {
        int i;
        for (i = 0; i < container.func_70302_i_(); ++i) {
            ItemStack stack = container.func_70301_a(i);
            if (stack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemStack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack) || stack.func_190916_E() >= stack.func_77976_d()) continue;
            stack.func_190917_f(1);
            container.func_70299_a(i, stack);
            return;
        }
        for (i = 0; i < container.func_70302_i_(); ++i) {
            if (!container.func_70301_a(i).func_190926_b()) continue;
            container.func_70299_a(i, itemStack);
            return;
        }
    }
}

