/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DeathMoneyListener {
    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        int deathMoneyLoss = Config.MONEY_LOSS_ON_DEATH;
        if (deathMoneyLoss == 0) {
            return;
        }
        String playerUUID = player.func_110124_au().toString();
        double balance = BalanceManager.getBalance(playerUUID);
        double newBalance = Math.max(balance - (double)deathMoneyLoss, 0.0);
        BalanceManager.setBalance(playerUUID, newBalance);
        player.func_145747_a((ITextComponent)new TranslationTextComponent("message.death_money_loss", new Object[]{deathMoneyLoss, newBalance}), Util.field_240973_b_);
    }
}

