/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Paycheck {
    private static long lastPaycheckTime = 0L;
    private static final long PAYCHECK_INTERVAL = TimeUnit.MINUTES.toMillis(30L);

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new Paycheck());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null || event.phase == TickEvent.Phase.START) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (Config.PAYCHECK_ENABLED && currentTime - lastPaycheckTime >= PAYCHECK_INTERVAL) {
            lastPaycheckTime = currentTime;
            this.payPlayers(server);
        }
    }

    private void payPlayers(MinecraftServer server) {
        List players = server.func_184103_al().func_181057_v();
        for (ServerPlayerEntity player : players) {
            String playerUUID = player.func_110124_au().toString();
            int paycheckAmount = Config.PAYCHECK_AMOUNT;
            BalanceManager.addMoneyToPlayer(server, playerUUID, paycheckAmount);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.sarosmoneymod.paycheck", new Object[]{paycheckAmount}), Util.field_240973_b_);
        }
    }
}

