/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.SarosMoneyModMod;
import de.sarocesch.sarosmoneymod.handlers.ShopSignHandler;
import de.sarocesch.sarosmoneymod.network.NetworkHandler;
import de.sarocesch.sarosmoneymod.network.SignUpdatePacket;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.EditSignScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="saros__money_mod")
public class SignShopListener {
    private static Field signField;
    private static EditSignScreen lastSignScreen;
    private static BlockPos lastSignPos;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EditSignScreen signScreen;
            Minecraft minecraft = Minecraft.func_71410_x();
            Screen currentScreen = minecraft.field_71462_r;
            if (lastSignScreen != null && !(currentScreen instanceof EditSignScreen)) {
                BlockPos signPos = lastSignPos;
                if (signPos != null) {
                    new Thread(() -> {
                        try {
                            Thread.sleep(500L);
                            NetworkHandler.INSTANCE.sendToServer((Object)new SignUpdatePacket(signPos));
                        }
                        catch (Exception e) {
                            SarosMoneyModMod.LOGGER.error("Sign update failed:", (Throwable)e);
                        }
                    }).start();
                }
                lastSignScreen = null;
                lastSignPos = null;
            }
            if (currentScreen instanceof EditSignScreen && (signScreen = (EditSignScreen)currentScreen) != lastSignScreen) {
                try {
                    SignTileEntity sign = (SignTileEntity)signField.get(signScreen);
                    lastSignPos = sign.func_174877_v();
                    lastSignScreen = signScreen;
                }
                catch (Exception e) {
                    SarosMoneyModMod.LOGGER.error("Failed to update sign reference:", (Throwable)e);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSignPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            BlockPos signPos;
            PlayerEntity player = (PlayerEntity)event.getEntity();
            World level = (World)event.getWorld();
            if (level.func_175625_s(signPos = event.getPos()) instanceof SignTileEntity) {
                SignTileEntity sign = (SignTileEntity)level.func_175625_s(signPos);
                CompoundNBT nbt = sign.getTileData();
                nbt.func_186854_a("OwnerUUID", player.func_110124_au());
                BlockState signState = level.func_180495_p(sign.func_174877_v());
                if (signState.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                    Direction facing = (Direction)signState.func_177229_b((Property)BlockStateProperties.field_208157_J);
                    BlockPos containerPos = signPos.func_177972_a(facing.func_176734_d());
                    nbt.func_74783_a("ContainerPos", new int[]{containerPos.func_177958_n(), containerPos.func_177956_o(), containerPos.func_177952_p()});
                }
                sign.func_70296_d();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        UUID ownerUUID;
        CompoundNBT nbt;
        SignTileEntity sign;
        PlayerEntity player = event.getPlayer();
        World level = player.field_70170_p;
        BlockPos pos = event.getPos();
        if (level.func_175625_s(pos) instanceof IInventory && (sign = SignShopListener.findLinkedSign(level, pos)) != null && (nbt = sign.getTileData()).func_74764_b("OwnerUUID")) {
            ownerUUID = nbt.func_186857_a("OwnerUUID");
            if (!player.func_110124_au().equals(ownerUUID) && !player.field_71075_bZ.field_75098_d) {
                event.setCanceled(true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("shop.protection.container_owner_only").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD}), true);
            }
        }
        if (level.func_175625_s(pos) instanceof SignTileEntity && (nbt = (sign = (SignTileEntity)level.func_175625_s(pos)).getTileData()).func_74764_b("OwnerUUID")) {
            ownerUUID = nbt.func_186857_a("OwnerUUID");
            if (!player.func_110124_au().equals(ownerUUID) && !player.field_71075_bZ.field_75098_d) {
                event.setCanceled(true);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("shop.protection.sign_owner_only").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD}), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        World level = event.getWorld();
        BlockPos pos = event.getPos();
        if (!level.field_72995_K) {
            UUID ownerUUID;
            CompoundNBT nbt;
            SignTileEntity sign;
            if (level.func_175625_s(pos) instanceof IInventory && (sign = SignShopListener.findLinkedSign(level, pos)) != null && (nbt = sign.getTileData()).func_74764_b("OwnerUUID")) {
                ownerUUID = nbt.func_186857_a("OwnerUUID");
                if (!player.func_110124_au().equals(ownerUUID)) {
                    event.setCanceled(true);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("shop.protection.container_use_owner_only").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD}), true);
                    return;
                }
            }
            if (level.func_175625_s(pos) instanceof SignTileEntity) {
                sign = (SignTileEntity)level.func_175625_s(pos);
                nbt = sign.getTileData();
                ownerUUID = nbt.func_74764_b("OwnerUUID") ? nbt.func_186857_a("OwnerUUID") : null;
                String[] lines = new String[4];
                for (int i = 0; i < 4; ++i) {
                    ITextComponent comp = sign.func_212366_a(i);
                    lines[i] = comp == null ? "" : comp.getString().trim();
                }
                String type = null;
                String itemId = null;
                String priceStr = null;
                if (lines[0].equalsIgnoreCase("[shop]")) {
                    type = lines[1].toLowerCase();
                    itemId = lines[2];
                    priceStr = lines[3];
                } else if (lines[0].equalsIgnoreCase("[buy]") || lines[0].equalsIgnoreCase("[sell]")) {
                    type = lines[0].substring(1, lines[0].length() - 1).toLowerCase();
                    if (lines[1].isEmpty() && !lines[3].isEmpty()) {
                        itemId = lines[2];
                        priceStr = lines[3];
                    } else {
                        itemId = lines[1];
                        priceStr = lines[2];
                    }
                } else {
                    return;
                }
                if (!"buy".equals(type) && !"sell".equals(type)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("shop.error.invalid_shop_type").func_240699_a_(TextFormatting.RED), true);
                    return;
                }
                try {
                    double priceValue;
                    double price = priceValue = Double.parseDouble(priceStr.replaceAll("[^0-9.,]", "").replace(',', '.'));
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId.toLowerCase()));
                    if (item == null) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("shop.error.invalid_item").func_240699_a_(TextFormatting.RED), true);
                        return;
                    }
                    ShopSignHandler.handleSignInteraction(ownerUUID, player, new ItemStack((IItemProvider)item).func_200301_q().getString(), price, type, pos);
                }
                catch (NumberFormatException e) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("shop.error.invalid_price_format").func_240699_a_(TextFormatting.RED), true);
                }
            }
        }
    }

    private static SignTileEntity findLinkedSign(World level, BlockPos containerPos) {
        BlockPos min = containerPos.func_177982_a(-5, -5, -5);
        BlockPos max = containerPos.func_177982_a(5, 5, 5);
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)min, (BlockPos)max)) {
            int[] coords;
            BlockPos linkedPos;
            SignTileEntity sign;
            CompoundNBT nbt;
            if (!(level.func_175625_s(pos) instanceof SignTileEntity) || !(nbt = (sign = (SignTileEntity)level.func_175625_s(pos)).getTileData()).func_74764_b("ContainerPos") || !(linkedPos = new BlockPos((coords = nbt.func_74759_k("ContainerPos"))[0], coords[1], coords[2])).equals((Object)containerPos)) continue;
            return sign;
        }
        return null;
    }

    static {
        lastSignScreen = null;
        lastSignPos = null;
        try {
            signField = EditSignScreen.class.getDeclaredField("sign");
            signField.setAccessible(true);
        }
        catch (Exception e) {
            SarosMoneyModMod.LOGGER.error("Reflection error:", (Throwable)e);
        }
    }
}

