/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.network;

import de.sarocesch.sarosmoneymod.SarosMoneyModMod;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.procedures.DepositProcedure;
import de.sarocesch.sarosmoneymod.procedures.WithdrawProcedure;
import de.sarocesch.sarosmoneymod.world.inventory.ATMGUIMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ATMGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private final String withdrawValue;

    public ATMGUIButtonMessage(PacketBuffer buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.withdrawValue = buffer.func_150789_c(Short.MAX_VALUE);
    }

    public ATMGUIButtonMessage(int buttonID, int x, int y, int z, String withdrawValue) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.withdrawValue = withdrawValue;
    }

    public static void buffer(ATMGUIButtonMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.func_180714_a(message.withdrawValue);
    }

    public static void handler(ATMGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity entity = context.getSender();
            if (entity != null) {
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                String withdrawValue = message.withdrawValue;
                ATMGUIButtonMessage.handleButtonAction((PlayerEntity)entity, buttonID, x, y, z, withdrawValue);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(PlayerEntity entity, int buttonID, int x, int y, int z, String withdrawValue) {
        World world = entity.field_70170_p;
        HashMap<String, Object> guistate = ATMGUIMenu.guistate;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)entity;
            if (buttonID == 0) {
                WithdrawProcedure.execute((Entity)serverPlayer, guistate, withdrawValue, serverPlayer);
            }
            if (buttonID == 1) {
                DepositProcedure.execute((Entity)serverPlayer, guistate, withdrawValue, serverPlayer);
            }
            int newBalance = (int)(BalanceManager.getPlayerBalance(serverPlayer) * 100.0);
            if (entity.field_71070_bA instanceof ATMGUIMenu) {
                ATMGUIMenu menu = (ATMGUIMenu)entity.field_71070_bA;
                menu.setBalanceCents(newBalance);
                menu.func_75142_b();
            }
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SarosMoneyModMod.addNetworkMessage(ATMGUIButtonMessage.class, ATMGUIButtonMessage::buffer, ATMGUIButtonMessage::new, ATMGUIButtonMessage::handler);
    }
}

