/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.procedures;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WithdrawProcedure {
    public static void execute(Entity entity, HashMap guistate, String withdrawValue, ServerPlayerEntity player) {
        if (entity == null || guistate == null) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity _player = (PlayerEntity)entity;
            if (!_player.field_70170_p.field_72995_K) {
                try {
                    int amount = Integer.parseInt(withdrawValue);
                    if (amount > 0) {
                        String playerUUID = _player.func_110124_au().toString();
                        double currentBalance = BalanceManager.getBalance(playerUUID);
                        if ((double)amount <= currentBalance) {
                            Map<Integer, ItemStack> items = WithdrawProcedure.convertAmountToItems(amount);
                            boolean canFitAllItems = WithdrawProcedure.canFitItems(_player, items);
                            if (canFitAllItems) {
                                WithdrawProcedure.addItemsToPlayerInventory(_player, items);
                                double newBalance = currentBalance - (double)amount;
                                BalanceManager.setBalance(playerUUID, newBalance);
                                _player.func_146105_b((ITextComponent)new StringTextComponent("\u00a79").func_230529_a_((ITextComponent)new TranslationTextComponent("lang.withdraw.previous_balance")).func_230529_a_((ITextComponent)new StringTextComponent(" " + currentBalance)), false);
                                _player.func_146105_b((ITextComponent)new StringTextComponent("\u00a7a").func_230529_a_((ITextComponent)new TranslationTextComponent("lang.withdraw.withdrawn_amount")).func_230529_a_((ITextComponent)new StringTextComponent(" " + amount)), false);
                                _player.func_146105_b((ITextComponent)new StringTextComponent("\u00a76").func_230529_a_((ITextComponent)new TranslationTextComponent("lang.withdraw.new_balance")).func_230529_a_((ITextComponent)new StringTextComponent(" " + newBalance)), false);
                                ((TextFieldWidget)guistate.get("text:withdraw")).func_146180_a("");
                            } else {
                                _player.func_146105_b((ITextComponent)new StringTextComponent("\u00a7c").func_230529_a_((ITextComponent)new TranslationTextComponent("lang.withdraw.not_enough_inventory")), false);
                            }
                        } else {
                            _player.func_146105_b((ITextComponent)new StringTextComponent("\u00a7c").func_230529_a_((ITextComponent)new TranslationTextComponent("lang.withdraw.not_enough_balance")), false);
                        }
                    } else {
                        _player.func_146105_b((ITextComponent)new StringTextComponent("\u00a7c").func_230529_a_((ITextComponent)new TranslationTextComponent("lang.withdraw.enter_positive_number")), false);
                    }
                }
                catch (NumberFormatException e) {
                    _player.func_146105_b((ITextComponent)new StringTextComponent("\u00a7c").func_230529_a_((ITextComponent)new TranslationTextComponent("lang.withdraw.enter_valid_number")), false);
                }
            }
        }
    }

    private static Map<Integer, ItemStack> convertAmountToItems(int amount) {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        int remaining = amount;
        int[] denominations = new int[]{500, 200, 100, 50, 20, 10, 5, 2, 1};
        ItemStack[] itemStacks = new ItemStack[]{new ItemStack((IItemProvider)SarosMoneyModModItems.EURO_500.get()), new ItemStack((IItemProvider)SarosMoneyModModItems.EURO_200.get()), new ItemStack((IItemProvider)SarosMoneyModModItems.EURO_100.get()), new ItemStack((IItemProvider)SarosMoneyModModItems.EURO_50.get()), new ItemStack((IItemProvider)SarosMoneyModModItems.EURO_20.get()), new ItemStack((IItemProvider)SarosMoneyModModItems.EURO_10.get()), new ItemStack((IItemProvider)SarosMoneyModModItems.EURO_5.get()), new ItemStack((IItemProvider)SarosMoneyModModItems.EURO_2.get()), new ItemStack((IItemProvider)SarosMoneyModModItems.EURO_1.get())};
        for (int i = 0; i < denominations.length; ++i) {
            int denom = denominations[i];
            int count = remaining / denom;
            if (count <= 0) continue;
            ItemStack stack = itemStacks[i].func_77946_l();
            stack.func_190920_e(count);
            items.put(denom, stack);
            remaining %= denom;
        }
        return items;
    }

    private static boolean canFitItems(PlayerEntity player, Map<Integer, ItemStack> items) {
        int freeSlots = 0;
        int slotsNeeded = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            ++freeSlots;
        }
        for (ItemStack stack : items.values()) {
            int remainingCount = stack.func_190916_E();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                int spaceInStack;
                ItemStack invStack = player.field_71071_by.func_70301_a(i);
                if (invStack.func_190926_b() || invStack.func_77973_b() != stack.func_77973_b() || (remainingCount -= (spaceInStack = invStack.func_77976_d() - invStack.func_190916_E())) > 0) continue;
                remainingCount = 0;
                break;
            }
            slotsNeeded += (remainingCount + stack.func_77976_d() - 1) / stack.func_77976_d();
        }
        return freeSlots >= slotsNeeded;
    }

    private static void addItemsToPlayerInventory(PlayerEntity player, Map<Integer, ItemStack> items) {
        for (ItemStack stack : items.values()) {
            while (!stack.func_190926_b()) {
                int remainingCount = stack.func_190916_E();
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack invStack = player.field_71071_by.func_70301_a(i);
                    if (invStack.func_190926_b() || invStack.func_77973_b() != stack.func_77973_b()) continue;
                    int spaceInStack = invStack.func_77976_d() - invStack.func_190916_E();
                    if (remainingCount <= spaceInStack) {
                        invStack.func_190917_f(remainingCount);
                        stack.func_190920_e(0);
                        break;
                    }
                    invStack.func_190917_f(spaceInStack);
                    remainingCount -= spaceInStack;
                }
                if (stack.func_190926_b()) continue;
                player.field_71071_by.func_70441_a(stack.func_77979_a(stack.func_77976_d()));
            }
        }
    }
}

