/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats;

import com.landmaster.cargoboats.Config;
import com.landmaster.cargoboats.block.BuoyBlock;
import com.landmaster.cargoboats.block.DockBlock;
import com.landmaster.cargoboats.block.MotorboatPathfindingNode;
import com.landmaster.cargoboats.block.entity.BuoyBlockEntity;
import com.landmaster.cargoboats.block.entity.DockBlockEntity;
import com.landmaster.cargoboats.entity.FluidMotorboat;
import com.landmaster.cargoboats.entity.Motorboat;
import com.landmaster.cargoboats.item.CapacityUpgradeItem;
import com.landmaster.cargoboats.item.FluidMotorboatItem;
import com.landmaster.cargoboats.item.LavaUpgradeItem;
import com.landmaster.cargoboats.item.MotorboatItem;
import com.landmaster.cargoboats.item.MotorboatProgrammerItem;
import com.landmaster.cargoboats.item.MotorboatTrackerItem;
import com.landmaster.cargoboats.item.SpeedUpgradeItem;
import com.landmaster.cargoboats.menu.BuoyMenu;
import com.landmaster.cargoboats.menu.FluidMotorboatMenu;
import com.landmaster.cargoboats.menu.MotorboatMenu;
import com.landmaster.cargoboats.menu.MotorboatProgrammerMenu;
import com.landmaster.cargoboats.network.ModifySchedulePacket;
import com.landmaster.cargoboats.network.SetAutomationPacket;
import com.landmaster.cargoboats.network.SetMotorboatPagePacket;
import com.landmaster.cargoboats.network.SyncBuoyPacket;
import com.landmaster.cargoboats.network.SyncFluidMotorboatPacket;
import com.landmaster.cargoboats.network.TrackMotorboatPacket;
import com.landmaster.cargoboats.util.MotorboatSchedule;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.energy.EmptyEnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.slf4j.Logger;

@Mod(value="cargoboats")
@EventBusSubscriber
public class CargoBoats {
    public static final String MODID = "cargoboats";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"cargoboats");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"cargoboats");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"cargoboats");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"cargoboats");
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"cargoboats");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"cargoboats");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"cargoboats");
    public static final DeferredRegister.DataComponents DATA_COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"cargoboats");
    public static final DeferredRegister<EntityDataSerializer<?>> ENTITY_DATA_SERIALIZERS = DeferredRegister.create((Registry)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"cargoboats");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"cargoboats");
    public static final Supplier<SoundEvent> MOTORBOAT_SOUND = SOUND_EVENTS.register("motorboat", SoundEvent::createVariableRangeEvent);
    public static final Supplier<SoundEvent> BOAT_HORN_SOUND = SOUND_EVENTS.register("boat_horn", SoundEvent::createVariableRangeEvent);
    public static final Supplier<EntityDataSerializer<MotorboatSchedule>> MOTORBOAT_SCHEDULE_EDS = ENTITY_DATA_SERIALIZERS.register("motorboat_schedule", () -> EntityDataSerializer.forValueType(MotorboatSchedule.STREAM_CODEC));
    public static final Supplier<DataComponentType<MotorboatSchedule>> MOTORBOAT_SCHEDULE = DATA_COMPONENTS.registerComponentType("motorboat_schedule", builder -> builder.networkSynchronized(MotorboatSchedule.STREAM_CODEC).persistent(MotorboatSchedule.CODEC));
    public static final Supplier<DataComponentType<UUID>> TRACKED_MOTORBOAT = DATA_COMPONENTS.registerComponentType("tracked_motorboat", builder -> builder.networkSynchronized(UUIDUtil.STREAM_CODEC).persistent(UUIDUtil.CODEC));
    public static final Supplier<DataComponentType<Boolean>> MOTORBOAT_HAS_DATA = DATA_COMPONENTS.registerComponentType("motorboat_has_data", builder -> builder.networkSynchronized(ByteBufCodecs.BOOL).persistent((Codec)Codec.BOOL));
    public static final Supplier<DataComponentType<CompoundTag>> MOTORBOAT_SAVE_DATA = DATA_COMPONENTS.registerComponentType("motorboat_save_data", builder -> builder.persistent(CompoundTag.CODEC));
    public static final DeferredBlock<DockBlock> DOCK = BLOCKS.registerBlock("dock", DockBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD));
    public static final DeferredBlock<BuoyBlock> BUOY = BLOCKS.registerBlock("buoy", BuoyBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASS).strength(0.8f).sound(SoundType.METAL).noCollission().lightLevel(state -> 12));
    public static final DeferredItem<BlockItem> DOCK_ITEM = ITEMS.registerSimpleBlockItem(DOCK);
    public static final DeferredItem<BlockItem> BUOY_ITEM = ITEMS.registerItem("buoy", props -> new PlaceOnWaterBlockItem((Block)BUOY.get(), props));
    public static final DeferredItem<MotorboatItem> MOTORBOAT_ITEM = ITEMS.registerItem("motorboat", MotorboatItem::new, new Item.Properties().stacksTo(1).fireResistant());
    public static final DeferredItem<MotorboatItem> FLUID_MOTORBOAT_ITEM = ITEMS.registerItem("fluid_motorboat", FluidMotorboatItem::new, new Item.Properties().stacksTo(1).fireResistant());
    public static final DeferredItem<MotorboatProgrammerItem> MOTORBOAT_PROGRAMMER = ITEMS.registerItem("motorboat_programmer", MotorboatProgrammerItem::new, new Item.Properties().stacksTo(1));
    public static final DeferredItem<SpeedUpgradeItem> SPEED_UPGRADE = ITEMS.registerItem("speed_upgrade", SpeedUpgradeItem::new);
    public static final DeferredItem<CapacityUpgradeItem> CAPACITY_UPGRADE = ITEMS.registerItem("capacity_upgrade", CapacityUpgradeItem::new);
    public static final DeferredItem<LavaUpgradeItem> LAVA_UPGRADE = ITEMS.registerItem("lava_upgrade", LavaUpgradeItem::new, new Item.Properties().fireResistant());
    public static final DeferredItem<MotorboatTrackerItem> MOTORBOAT_TRACKER = ITEMS.registerItem("motorboat_tracker", MotorboatTrackerItem::new, new Item.Properties().stacksTo(1));
    public static final Supplier<EntityType<Motorboat>> MOTORBOAT = ENTITIES.register("motorboat", () -> EntityType.Builder.of(Motorboat::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build("motorboat"));
    public static final Supplier<EntityType<FluidMotorboat>> FLUID_MOTORBOAT = ENTITIES.register("fluid_motorboat", () -> EntityType.Builder.of(FluidMotorboat::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build("fluid_motorboat"));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> CREATIVE_TAB = CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.cargoboats")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> MOTORBOAT_ITEM.toStack()).displayItems((parameters, output) -> {
        output.accept(DOCK_ITEM);
        output.accept(BUOY_ITEM);
        output.accept(MOTORBOAT_ITEM);
        output.accept(FLUID_MOTORBOAT_ITEM);
        output.accept(MOTORBOAT_PROGRAMMER);
        output.accept(SPEED_UPGRADE);
        output.accept(CAPACITY_UPGRADE);
        output.accept(LAVA_UPGRADE);
        output.accept(MOTORBOAT_TRACKER);
    }).build());
    public static final Supplier<MenuType<MotorboatMenu>> MOTORBOAT_MENU = MENU_TYPES.register("motorboat", () -> new MenuType(MotorboatMenu::new, FeatureFlags.DEFAULT_FLAGS));
    public static final Supplier<MenuType<FluidMotorboatMenu>> FLUID_MOTORBOAT_MENU = MENU_TYPES.register("fluid_motorboat", () -> new MenuType(FluidMotorboatMenu::new, FeatureFlags.DEFAULT_FLAGS));
    public static final Supplier<MenuType<MotorboatProgrammerMenu>> MOTORBOAT_PROGRAMMER_MENU = MENU_TYPES.register("motorboat_programmer", () -> IMenuTypeExtension.create(MotorboatProgrammerMenu::new));
    public static final Supplier<MenuType<BuoyMenu>> BUOY_MENU = MENU_TYPES.register("buoy", () -> IMenuTypeExtension.create(BuoyMenu::new));
    public static final Supplier<BlockEntityType<DockBlockEntity>> DOCK_TE = BLOCK_ENTITY_TYPES.register("dock", () -> BlockEntityType.Builder.of(DockBlockEntity::new, (Block[])new Block[]{(Block)DOCK.get()}).build(null));
    public static final Supplier<BlockEntityType<BuoyBlockEntity>> BUOY_TE = BLOCK_ENTITY_TYPES.register("buoy", () -> BlockEntityType.Builder.of(BuoyBlockEntity::new, (Block[])new Block[]{(Block)BUOY.get()}).build(null));
    public static final BlockCapability<MotorboatPathfindingNode, Void> MOTORBOAT_PATHFINDING_NODE = BlockCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"motorboat_pathfinding_node"), MotorboatPathfindingNode.class);
    public static final TicketController TICKET_CONTROLLER = new TicketController(ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"ticket_controller"));

    public CargoBoats(IEventBus modEventBus, ModContainer modContainer) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        ENTITIES.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        ATTACHMENT_TYPES.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        DATA_COMPONENTS.register(modEventBus);
        ENTITY_DATA_SERIALIZERS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    @SubscribeEvent
    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(Capabilities.ItemHandler.ENTITY, MOTORBOAT.get(), (entity, ctx) -> entity.combinedHandler);
        event.registerEntity(Capabilities.ItemHandler.ENTITY_AUTOMATION, MOTORBOAT.get(), (entity, ctx) -> entity.itemHandler);
        event.registerEntity(Capabilities.EnergyStorage.ENTITY, MOTORBOAT.get(), (entity, ctx) -> entity);
        event.registerEntity(Capabilities.ItemHandler.ENTITY, FLUID_MOTORBOAT.get(), (entity, ctx) -> entity.combinedHandler);
        event.registerEntity(Capabilities.FluidHandler.ENTITY, FLUID_MOTORBOAT.get(), (entity, ctx) -> entity.tank);
        event.registerEntity(Capabilities.EnergyStorage.ENTITY, FLUID_MOTORBOAT.get(), (entity, ctx) -> entity);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, DOCK_TE.get(), (te, dir) -> te.getDockedMotorboat().map(motorboat -> (IItemHandler)motorboat.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, null)).orElse(EmptyItemHandler.INSTANCE));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, DOCK_TE.get(), (te, dir) -> te.getDockedMotorboat().map(motorboat -> (IEnergyStorage)motorboat.getCapability(Capabilities.EnergyStorage.ENTITY, null)).orElse((IEnergyStorage)EmptyEnergyStorage.INSTANCE));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, DOCK_TE.get(), (te, dir) -> te.getDockedMotorboat().map(motorboat -> (IFluidHandler)motorboat.getCapability(Capabilities.FluidHandler.ENTITY, null)).orElse((IFluidHandler)EmptyFluidHandler.INSTANCE));
        event.registerBlockEntity(MOTORBOAT_PATHFINDING_NODE, DOCK_TE.get(), (te, ctx) -> te);
        event.registerBlockEntity(MOTORBOAT_PATHFINDING_NODE, BUOY_TE.get(), (te, ctx) -> te);
    }

    @SubscribeEvent
    private static void modifyComponents(ModifyDefaultComponentsEvent event) {
        event.modify(MOTORBOAT_PROGRAMMER, builder -> builder.set(MOTORBOAT_SCHEDULE.get(), (Object)MotorboatSchedule.INITIAL));
    }

    @SubscribeEvent
    private static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(SetAutomationPacket.TYPE, SetAutomationPacket.STREAM_CODEC, SetAutomationPacket::handle);
        registrar.playBidirectional(ModifySchedulePacket.TYPE, ModifySchedulePacket.STREAM_CODEC, ModifySchedulePacket::handle);
        registrar.playToClient(TrackMotorboatPacket.TYPE, TrackMotorboatPacket.STREAM_CODEC, TrackMotorboatPacket::handle);
        registrar.playToClient(SyncFluidMotorboatPacket.TYPE, SyncFluidMotorboatPacket.STREAM_CODEC, SyncFluidMotorboatPacket::handle);
        registrar.playBidirectional(SetMotorboatPagePacket.TYPE, SetMotorboatPagePacket.STREAM_CODEC, SetMotorboatPagePacket::handle);
        registrar.playBidirectional(SyncBuoyPacket.TYPE, SyncBuoyPacket.STREAM_CODEC, SyncBuoyPacket::handle);
    }

    @SubscribeEvent
    private static void registerTicketControllers(RegisterTicketControllersEvent event) {
        event.register(TICKET_CONTROLLER);
    }
}

