/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.block;

import com.landmaster.cargoboats.block.WrenchInteractable;
import com.landmaster.cargoboats.block.entity.BuoyBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BuoyBlock
extends BaseEntityBlock
implements WrenchInteractable {
    protected static final VoxelShape AABB = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);

    public BuoyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nonnull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return BuoyBlock.simpleCodec(BuoyBlock::new);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.cargoboats.motorboat.buoy").withStyle(ChatFormatting.AQUA));
    }

    @Nonnull
    protected VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return AABB;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new BuoyBlockEntity(pos, state);
    }

    @Nonnull
    protected RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nonnull
    protected InteractionResult useWithoutItem(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof BuoyBlockEntity) {
            BuoyBlockEntity buoyBlockEntity = (BuoyBlockEntity)blockentity;
            player.openMenu((MenuProvider)buoyBlockEntity, pos);
        }
        return InteractionResult.CONSUME;
    }
}

