/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public interface WrenchInteractable {
    default public InteractionResult disassemble(Level level, BlockPos pos, Player player) {
        ItemStack stack;
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.getInventory());
        boolean canInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)(stack = new ItemStack((ItemLike)((Block)this).asItem())), (boolean)true).isEmpty();
        if (canInsert) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
            level.destroyBlock(pos, false);
        }
        return canInsert ? InteractionResult.sidedSuccess((boolean)level.isClientSide) : InteractionResult.FAIL;
    }

    default public InteractionResult rotate(Level level, BlockPos pos, Player player) {
        BlockState blockState = level.getBlockState(pos);
        BlockState newBlockState = blockState.rotate((LevelAccessor)level, pos, Rotation.CLOCKWISE_90);
        if (newBlockState != blockState) {
            level.setBlockAndUpdate(pos, newBlockState);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

