/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.block.entity;

import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.block.BuoyBlock;
import com.landmaster.cargoboats.block.MotorboatPathfindingNode;
import com.landmaster.cargoboats.menu.BuoyMenu;
import it.unimi.dsi.fastutil.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BuoyBlockEntity
extends BlockEntity
implements MotorboatPathfindingNode,
MenuProvider {
    public int offsetX = 0;
    public int offsetZ = 0;

    public BuoyBlockEntity(BlockPos pos, BlockState blockState) {
        super(CargoBoats.BUOY_TE.get(), pos, blockState);
    }

    protected void loadAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.offsetX = tag.getByte("OffsetX");
        this.offsetZ = tag.getByte("OffsetZ");
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putByte("OffsetX", (byte)this.offsetX);
        tag.putByte("OffsetZ", (byte)this.offsetZ);
    }

    @Override
    public Pair<BlockPos, BlockPos> getBoxForMotorboatPathfinding() {
        return Pair.of((Object)this.worldPosition.offset(this.offsetX, -1, this.offsetZ), (Object)this.worldPosition.offset(this.offsetX, 1, this.offsetZ));
    }

    @Override
    public boolean doBoatHorn() {
        return false;
    }

    @Override
    public int defaultStopTime() {
        return 0;
    }

    @Nonnull
    public Component getDisplayName() {
        return ((BuoyBlock)CargoBoats.BUOY.get()).getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @Nonnull Inventory playerInventory, @Nonnull Player player) {
        return new BuoyMenu(containerId, this);
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider registries) {
        CompoundTag result = new CompoundTag();
        this.saveAdditional(result, registries);
        return result;
    }
}

