/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.block.entity;

import com.google.common.collect.ImmutableList;
import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.block.DockBlock;
import com.landmaster.cargoboats.block.MotorboatPathfindingNode;
import com.landmaster.cargoboats.entity.Motorboat;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class DockBlockEntity
extends BlockEntity
implements MotorboatPathfindingNode {
    @Nullable
    private UUID dockedMotorboatId;
    @Nullable
    private Motorboat dockedMotorboat;

    public DockBlockEntity(BlockPos pos, BlockState blockState) {
        super(CargoBoats.DOCK_TE.get(), pos, blockState);
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof DockBlockEntity) {
            DockBlockEntity dockBlockEntity = (DockBlockEntity)t;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (dockBlockEntity.dockedMotorboatId == null) {
                    Optional<Motorboat> boatToDock = dockBlockEntity.getMotorboatToDock();
                    if (boatToDock.isPresent()) {
                        dockBlockEntity.dockedMotorboatId = boatToDock.get().getUUID();
                        dockBlockEntity.dockedMotorboat = boatToDock.get();
                        dockBlockEntity.invalidateCapabilities();
                        dockBlockEntity.setChanged();
                    }
                } else {
                    Entity entity;
                    boolean invalidateCaps = false;
                    if (dockBlockEntity.dockedMotorboat == null && (entity = serverLevel.getEntity(dockBlockEntity.dockedMotorboatId)) instanceof Motorboat) {
                        Motorboat motorboat;
                        dockBlockEntity.dockedMotorboat = motorboat = (Motorboat)entity;
                        invalidateCaps = true;
                    }
                    if (dockBlockEntity.dockedMotorboat == null || serverLevel.getEntity(dockBlockEntity.dockedMotorboatId) != dockBlockEntity.dockedMotorboat || !dockBlockEntity.dockedMotorboat.getBoundingBox().intersects(dockBlockEntity.getMotorboatAABB())) {
                        dockBlockEntity.dockedMotorboatId = null;
                        dockBlockEntity.dockedMotorboat = null;
                        invalidateCaps = true;
                    }
                    if (invalidateCaps) {
                        dockBlockEntity.invalidateCapabilities();
                        dockBlockEntity.setChanged();
                    }
                }
            }
        }
    }

    public AABB getMotorboatAABB() {
        Pair<BlockPos, BlockPos> pair = this.getBoxForMotorboatPathfinding();
        return AABB.encapsulatingFullBlocks((BlockPos)((BlockPos)pair.first()), (BlockPos)((BlockPos)pair.second()));
    }

    @Override
    public Pair<BlockPos, BlockPos> getBoxForMotorboatPathfinding() {
        Direction facingDir = (Direction)this.getBlockState().getValue((Property)DockBlock.FACING);
        Direction ccwDir = facingDir.getCounterClockWise();
        BlockPos pos = this.getBlockPos();
        BlockPos pos1 = pos.relative(facingDir).relative(ccwDir).below(2);
        BlockPos pos2 = pos.relative(facingDir, 4).relative(ccwDir, -1).above(2);
        return Pair.of((Object)new BlockPos(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()), Math.min(pos1.getZ(), pos2.getZ())), (Object)new BlockPos(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()), Math.max(pos1.getZ(), pos2.getZ())));
    }

    @Override
    public boolean isMotorboatDocked(Motorboat motorboat) {
        return this.dockedMotorboat != null && this.dockedMotorboat == motorboat;
    }

    @Override
    public boolean doBoatHorn() {
        return true;
    }

    @Override
    public int defaultStopTime() {
        return 200;
    }

    public List<Motorboat> getMotorboatCandidates() {
        if (this.level == null) {
            return ImmutableList.of();
        }
        return this.level.getEntitiesOfClass(Motorboat.class, this.getMotorboatAABB());
    }

    public Optional<Motorboat> getMotorboatToDock() {
        List<Motorboat> cands = this.getMotorboatCandidates();
        if (cands.isEmpty()) {
            return Optional.empty();
        }
        for (Motorboat cand : cands) {
            if (!cand.nextStop().filter(entry -> entry.matchesDock(this.getBlockPos(), this.level)).isPresent()) continue;
            return Optional.of(cand);
        }
        return Optional.of(cands.getFirst());
    }

    public Optional<Motorboat> getDockedMotorboat() {
        return Optional.ofNullable(this.dockedMotorboat);
    }

    protected void loadAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.hasUUID("DockedMotorboat")) {
            this.dockedMotorboatId = tag.getUUID("DockedMotorboat");
            this.dockedMotorboat = null;
        }
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.dockedMotorboatId != null) {
            tag.putUUID("DockedMotorboat", this.dockedMotorboatId);
        }
    }
}

