/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.entity;

import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.Config;
import com.landmaster.cargoboats.entity.Motorboat;
import com.landmaster.cargoboats.menu.FluidMotorboatMenu;
import com.landmaster.cargoboats.network.SyncFluidMotorboatPacket;
import com.landmaster.cargoboats.util.Util;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class FluidMotorboat
extends Motorboat {
    private FluidStack oldFluidStack = FluidStack.EMPTY;
    public final FluidTank tank = new FluidTank(Config.MOTORBOAT_BASE_FLUID_CAPACITY.getAsInt());

    public FluidMotorboat(EntityType<? extends Motorboat> entityType, Level level) {
        super(entityType, level, 0);
    }

    public FluidMotorboat(Level level, double x, double y, double z) {
        this(CargoBoats.FLUID_MOTORBOAT.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    @Override
    public void addMotorboatSaveData(CompoundTag compound) {
        super.addMotorboatSaveData(compound);
        compound.put("FluidTank", (Tag)this.tank.writeToNBT((HolderLookup.Provider)this.registryAccess(), new CompoundTag()));
    }

    @Override
    public void readMotorboatSaveData(CompoundTag compound) {
        super.readMotorboatSaveData(compound);
        this.tank.readFromNBT((HolderLookup.Provider)this.registryAccess(), compound.getCompound("FluidTank"));
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @Nonnull Inventory playerInventory, @Nonnull Player player) {
        if (player.isSpectator()) {
            return null;
        }
        return new FluidMotorboatMenu(containerId, playerInventory, this);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            int newCapacity;
            int capacityUpgradeCount = Util.countItem((IItemHandler)this.upgradeHandler, (Item)CargoBoats.CAPACITY_UPGRADE.get());
            int n = newCapacity = capacityUpgradeCount > 0 ? ((Integer)((List)Config.MOTORBOAT_FLUID_CAPACITY.get()).get(capacityUpgradeCount - 1)).intValue() : Config.MOTORBOAT_BASE_FLUID_CAPACITY.getAsInt();
            if (newCapacity != this.tank.getCapacity() || !FluidStack.matches((FluidStack)this.oldFluidStack, (FluidStack)this.tank.getFluid())) {
                this.tank.setCapacity(newCapacity);
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new SyncFluidMotorboatPacket(this.getId(), this.tank.getFluid(), this.tank.getCapacity()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.oldFluidStack = this.tank.getFluid().copy();
            }
        }
    }

    public void startSeenByPlayer(@Nonnull ServerPlayer serverPlayer) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncFluidMotorboatPacket(this.getId(), this.tank.getFluid(), this.tank.getCapacity()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    @Nonnull
    public Item getDropItem() {
        return CargoBoats.FLUID_MOTORBOAT_ITEM.asItem();
    }
}

